/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.netmgt.dao.api.VlanDao;
import org.opennms.netmgt.dao.mock.AbstractMockDao;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsVlan;

public class MockVlanDao
extends AbstractMockDao<OnmsVlan, Integer>
implements VlanDao {
    private AtomicInteger m_id = new AtomicInteger(0);

    @Override
    protected Integer getId(OnmsVlan entity) {
        return entity.getId();
    }

    @Override
    protected void generateId(OnmsVlan entity) {
        entity.setId(Integer.valueOf(this.m_id.getAndIncrement()));
    }

    public void markDeletedIfNodeDeleted() {
        for (OnmsVlan vlan : this.findAll()) {
            if (vlan.getNode() == null || !"D".equals(vlan.getNode().getType())) continue;
            vlan.setStatus(OnmsArpInterface.StatusType.DELETED);
        }
    }

    public void deactivateForNodeIdIfOlderThan(int nodeId, Date scanTime) {
        for (OnmsVlan vlan : this.getVlansForNodeIdIfOlderThan(nodeId, scanTime)) {
            if (!OnmsArpInterface.StatusType.ACTIVE.equals((Object)vlan.getStatus())) continue;
            vlan.setStatus(OnmsArpInterface.StatusType.INACTIVE);
        }
    }

    public void deleteForNodeIdIfOlderThan(int nodeId, Date scanTime) {
        List<OnmsVlan> vlans = this.getVlansForNodeIdIfOlderThan(nodeId, scanTime);
        for (OnmsVlan vlan : vlans) {
            if (OnmsArpInterface.StatusType.ACTIVE.equals((Object)vlan.getStatus())) continue;
            this.delete(vlan);
        }
    }

    public void setStatusForNode(Integer nodeId, OnmsArpInterface.StatusType action) {
        for (OnmsVlan vlan : this.findAll()) {
            if (vlan.getNode() == null || vlan.getNode().getId() != nodeId) continue;
            vlan.setStatus(action);
        }
    }

    private List<OnmsVlan> getVlansForNodeIdIfOlderThan(int nodeId, Date scanTime) {
        ArrayList<OnmsVlan> vlans = new ArrayList<OnmsVlan>();
        for (OnmsVlan vlan : this.findAll()) {
            if (vlan.getNode() != null && vlan.getNode().getId() != nodeId || vlan.getLastPollTime() == null || !vlan.getLastPollTime().before(scanTime)) continue;
            vlans.add(vlan);
        }
        return vlans;
    }

    public OnmsVlan findByNodeAndVlan(Integer nodeId, Integer vlanId) {
        for (OnmsVlan vlan : this.findAll()) {
            if (vlan.getNode() != null && vlan.getNode().getId() != nodeId || vlan.getVlanId() != vlanId) continue;
            return vlan;
        }
        return null;
    }
}

