/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.netmgt.dao.api.StpNodeDao;
import org.opennms.netmgt.dao.mock.AbstractMockDao;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsStpNode;

public class MockStpNodeDao
extends AbstractMockDao<OnmsStpNode, Integer>
implements StpNodeDao {
    private AtomicInteger m_id = new AtomicInteger(0);

    @Override
    protected Integer getId(OnmsStpNode entity) {
        return entity.getId();
    }

    @Override
    protected void generateId(OnmsStpNode entity) {
        entity.setId(Integer.valueOf(this.m_id.getAndIncrement()));
    }

    public void markDeletedIfNodeDeleted() {
        for (OnmsStpNode node : this.findAll()) {
            if (node.getNode() == null || !"D".equals(node.getNode().getType())) continue;
            node.setStatus(OnmsArpInterface.StatusType.DELETED);
        }
    }

    public void deactivateForNodeIdIfOlderThan(int nodeId, Date scanTime) {
        for (OnmsStpNode node : this.getStpNodesForNodeIdIfOlderThan(nodeId, scanTime)) {
            if (!OnmsArpInterface.StatusType.ACTIVE.equals((Object)node.getStatus())) continue;
            node.setStatus(OnmsArpInterface.StatusType.INACTIVE);
        }
    }

    public void deleteForNodeIdIfOlderThan(int nodeId, Date scanTime) {
        List<OnmsStpNode> nodes = this.getStpNodesForNodeIdIfOlderThan(nodeId, scanTime);
        for (OnmsStpNode node : nodes) {
            if (OnmsArpInterface.StatusType.ACTIVE.equals((Object)node.getStatus())) continue;
            this.delete(node);
        }
    }

    public void setStatusForNode(Integer nodeId, OnmsArpInterface.StatusType action) {
        for (OnmsStpNode node : this.findAll()) {
            if (node.getNode() == null || node.getNode().getId() != nodeId) continue;
            node.setStatus(action);
        }
    }

    public OnmsStpNode findByNodeAndVlan(Integer nodeId, Integer baseVlan) {
        for (OnmsStpNode node : this.findAll()) {
            if (node.getNode() == null || node.getNode().getId() != nodeId || node.getBaseVlan() != baseVlan) continue;
            return node;
        }
        return null;
    }

    private List<OnmsStpNode> getStpNodesForNodeIdIfOlderThan(int nodeId, Date scanTime) {
        ArrayList<OnmsStpNode> nodes = new ArrayList<OnmsStpNode>();
        for (OnmsStpNode node : this.findAll()) {
            if (node.getNode() != null && node.getNode().getId() != nodeId || node.getLastPollTime() == null || !node.getLastPollTime().before(scanTime)) continue;
            nodes.add(node);
        }
        return nodes;
    }
}

