/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.netmgt.dao.api.StpInterfaceDao;
import org.opennms.netmgt.dao.mock.AbstractMockDao;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsStpInterface;

public class MockStpInterfaceDao
extends AbstractMockDao<OnmsStpInterface, Integer>
implements StpInterfaceDao {
    private AtomicInteger m_id = new AtomicInteger(0);

    @Override
    protected Integer getId(OnmsStpInterface entity) {
        return entity.getId();
    }

    @Override
    protected void generateId(OnmsStpInterface entity) {
        entity.setId(Integer.valueOf(this.m_id.getAndIncrement()));
    }

    public void markDeletedIfNodeDeleted() {
        for (OnmsStpInterface iface : this.findAll()) {
            if (iface.getNode() == null || !"D".equals(iface.getNode().getType())) continue;
            iface.setStatus(OnmsArpInterface.StatusType.DELETED);
        }
    }

    public void deactivateForNodeIdIfOlderThan(int nodeId, Date scanTime) {
        for (OnmsStpInterface iface : this.getStpInterfacesForNodeIdIfOlderThan(nodeId, scanTime)) {
            if (!OnmsArpInterface.StatusType.ACTIVE.equals((Object)iface.getStatus())) continue;
            iface.setStatus(OnmsArpInterface.StatusType.INACTIVE);
        }
    }

    public void deleteForNodeIdIfOlderThan(int nodeId, Date scanTime) {
        List<OnmsStpInterface> ifaces = this.getStpInterfacesForNodeIdIfOlderThan(nodeId, scanTime);
        for (OnmsStpInterface iface : ifaces) {
            if (OnmsArpInterface.StatusType.ACTIVE.equals((Object)iface.getStatus())) continue;
            this.delete(iface);
        }
    }

    public void setStatusForNode(Integer nodeId, OnmsArpInterface.StatusType action) {
        for (OnmsStpInterface iface : this.findAll()) {
            if (iface.getNode() == null || iface.getNode().getId() != nodeId) continue;
            iface.setStatus(action);
        }
    }

    public void setStatusForNodeAndIfIndex(Integer nodeId, Integer ifIndex, OnmsArpInterface.StatusType action) {
        for (OnmsStpInterface iface : this.findAll()) {
            if (iface.getNode() == null || iface.getNode().getId() != nodeId || iface.getIfIndex() != ifIndex) continue;
            iface.setStatus(action);
        }
    }

    public OnmsStpInterface findByNodeAndVlan(Integer nodeId, Integer bridgePort, Integer vlan) {
        for (OnmsStpInterface iface : this.findAll()) {
            if (iface.getNode() == null || iface.getNode().getId() != nodeId || iface.getBridgePort() != bridgePort || iface.getVlan() != vlan) continue;
            return iface;
        }
        return null;
    }

    private List<OnmsStpInterface> getStpInterfacesForNodeIdIfOlderThan(int nodeId, Date scanTime) {
        ArrayList<OnmsStpInterface> ifaces = new ArrayList<OnmsStpInterface>();
        for (OnmsStpInterface iface : this.findAll()) {
            if (iface.getNode() != null && iface.getNode().getId() != nodeId || iface.getLastPollTime() == null || !iface.getLastPollTime().before(scanTime)) continue;
            ifaces.add(iface);
        }
        return ifaces;
    }
}

