/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.netmgt.dao.api.IpRouteInterfaceDao;
import org.opennms.netmgt.dao.mock.AbstractMockDao;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsIpRouteInterface;
import org.opennms.netmgt.model.OnmsNode;

public class MockIpRouteInterfaceDao
extends AbstractMockDao<OnmsIpRouteInterface, Integer>
implements IpRouteInterfaceDao {
    private AtomicInteger m_id = new AtomicInteger(0);

    @Override
    protected Integer getId(OnmsIpRouteInterface entity) {
        return entity.getId();
    }

    @Override
    protected void generateId(OnmsIpRouteInterface entity) {
        entity.setId(Integer.valueOf(this.m_id.getAndIncrement()));
    }

    public void markDeletedIfNodeDeleted() {
        for (OnmsIpRouteInterface iface : this.findAll()) {
            OnmsNode node = iface.getNode();
            if (node == null || !"D".equals(node.getType())) continue;
            iface.setStatus(OnmsArpInterface.StatusType.DELETED);
        }
    }

    public void deactivateForNodeIdIfOlderThan(int nodeId, Date scanTime) {
        for (OnmsIpRouteInterface iface : this.getInterfacesForNodeIdIfOlderThan(nodeId, scanTime)) {
            if (!iface.getStatus().equals((Object)OnmsArpInterface.StatusType.ACTIVE)) continue;
            iface.setStatus(OnmsArpInterface.StatusType.INACTIVE);
        }
    }

    public void deleteForNodeIdIfOlderThan(int nodeId, Date scanTime) {
        List<OnmsIpRouteInterface> ifaces = this.getInterfacesForNodeIdIfOlderThan(nodeId, scanTime);
        for (OnmsIpRouteInterface iface : ifaces) {
            if (iface.getStatus().equals((Object)OnmsArpInterface.StatusType.ACTIVE)) continue;
            this.delete(iface);
        }
    }

    public void setStatusForNode(Integer nodeId, OnmsArpInterface.StatusType action) {
        for (OnmsIpRouteInterface iface : this.findAll()) {
            if (iface.getNode() == null || iface.getNode().getId() != nodeId) continue;
            iface.setStatus(action);
        }
    }

    public void setStatusForNodeAndIfIndex(Integer nodeId, Integer ifIndex, OnmsArpInterface.StatusType action) {
        for (OnmsIpRouteInterface iface : this.findAll()) {
            if (iface.getNode() == null || iface.getNode().getId() != nodeId || iface.getRouteIfIndex() != ifIndex) continue;
            iface.setStatus(action);
        }
    }

    public OnmsIpRouteInterface findByNodeAndDest(Integer nodeId, String routeDest) {
        for (OnmsIpRouteInterface iface : this.findAll()) {
            if (iface.getNode() == null || iface.getNode().getId() != nodeId || !routeDest.equals(iface.getRouteDest())) continue;
            return iface;
        }
        return null;
    }

    private List<OnmsIpRouteInterface> getInterfacesForNodeIdIfOlderThan(int nodeId, Date scanTime) {
        ArrayList<OnmsIpRouteInterface> ifaces = new ArrayList<OnmsIpRouteInterface>();
        for (OnmsIpRouteInterface iface : this.findAll()) {
            OnmsNode node = iface.getNode();
            if (node == null || nodeId != node.getId() || iface.getLastPollTime() != null && !iface.getLastPollTime().before(scanTime)) continue;
            ifaces.add(iface);
        }
        return ifaces;
    }
}

