/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockEventProxy
implements EventProxy {
    private static final Logger LOG = LoggerFactory.getLogger(MockEventProxy.class);
    private List<Event> m_events = new ArrayList<Event>();

    public void send(Event event) throws EventProxyException {
        LOG.debug("Received event: {}", (Object)event);
        this.m_events.add(event);
    }

    public void send(Log eventLog) throws EventProxyException {
        if (eventLog.getEvents() != null) {
            List events = eventLog.getEvents().getEventCollection();
            LOG.debug("Received events: {}", (Object)events);
            this.m_events.addAll(events);
        }
    }

    public void resetEvents() {
        this.m_events.clear();
    }

    public List<Event> getEvents() {
        return this.m_events;
    }
}

