/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.util.Collection;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.AllRestriction;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.netmgt.dao.api.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.mock.AbstractMockDao;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsArpInterface;

public class MockDataLinkInterfaceDao
extends AbstractMockDao<DataLinkInterface, Integer>
implements DataLinkInterfaceDao {
    private AtomicInteger m_id = new AtomicInteger(0);

    @Override
    protected void generateId(DataLinkInterface dli) {
        dli.setId(this.m_id.incrementAndGet());
    }

    @Override
    protected Integer getId(DataLinkInterface dli) {
        return dli.getId();
    }

    public Collection<DataLinkInterface> findAll(Integer offset, Integer limit) {
        CriteriaBuilder builder = new CriteriaBuilder(DataLinkInterface.class);
        builder.offset(offset).limit(limit);
        return this.findMatching(builder.toCriteria());
    }

    public DataLinkInterface findById(Integer id) {
        return (DataLinkInterface)this.get(id);
    }

    public Collection<DataLinkInterface> findByNodeId(Integer nodeId) {
        CriteriaBuilder builder = new CriteriaBuilder(DataLinkInterface.class);
        builder.eq("node.id", (Object)nodeId);
        return this.findMatching(builder.toCriteria());
    }

    public Collection<DataLinkInterface> findByNodeParentId(Integer nodeParentId) {
        CriteriaBuilder builder = new CriteriaBuilder(DataLinkInterface.class);
        builder.eq("nodeParentId", (Object)nodeParentId);
        return this.findMatching(builder.toCriteria());
    }

    public void markDeletedIfNodeDeleted() {
        CriteriaBuilder builder = new CriteriaBuilder(DataLinkInterface.class);
        builder.alias("node", "node").eq("node.type", (Object)"D");
        for (DataLinkInterface dataLinkIface : this.findMatching(builder.toCriteria())) {
            dataLinkIface.setStatus(OnmsArpInterface.StatusType.DELETED);
            this.saveOrUpdate(dataLinkIface);
        }
    }

    public Collection<DataLinkInterface> findByNodeIdAndIfIndex(Integer nodeId, Integer ifIndex) {
        CriteriaBuilder builder = new CriteriaBuilder(DataLinkInterface.class);
        builder.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        builder.eq("node.id", (Object)nodeId);
        builder.eq("ifIndex", (Object)ifIndex);
        return this.findMatching(builder.toCriteria());
    }

    public Collection<DataLinkInterface> findByParentNodeIdAndIfIndex(Integer nodeParentId, Integer parentIfIndex) {
        CriteriaBuilder builder = new CriteriaBuilder(DataLinkInterface.class);
        builder.eq("nodeParentId", (Object)nodeParentId);
        builder.eq("parentIfIndex", (Object)parentIfIndex);
        return this.findMatching(builder.toCriteria());
    }

    public void deactivateIfOlderThan(Date scanTime, String source) {
        CriteriaBuilder builder = new CriteriaBuilder(DataLinkInterface.class);
        builder.eq("source", (Object)source);
        builder.lt("lastPollTime", (Object)scanTime);
        builder.eq("status", (Object)OnmsArpInterface.StatusType.ACTIVE);
        for (DataLinkInterface iface : this.findMatching(builder.toCriteria())) {
            iface.setStatus(OnmsArpInterface.StatusType.INACTIVE);
            this.saveOrUpdate(iface);
        }
    }

    public void deleteIfOlderThan(Date scanTime, String source) {
        CriteriaBuilder builder = new CriteriaBuilder(DataLinkInterface.class);
        builder.eq("source", (Object)source);
        builder.lt("lastPollTime", (Object)scanTime);
        builder.ne("status", (Object)OnmsArpInterface.StatusType.DELETED);
        for (DataLinkInterface iface : this.findMatching(builder.toCriteria())) {
            this.delete(iface);
        }
    }

    public void setStatusForNode(Integer nodeid, OnmsArpInterface.StatusType action) {
        this.setStatusForNode(nodeid, null, action);
    }

    public void setStatusForNode(Integer nodeid, String source, OnmsArpInterface.StatusType action) {
        CriteriaBuilder builder = new CriteriaBuilder(DataLinkInterface.class);
        if (source != null) {
            builder.eq("source", (Object)source);
        }
        builder.or((Restriction)new EqRestriction("node.id", (Object)nodeid), (Restriction)new EqRestriction("nodeParentId", (Object)nodeid));
        for (DataLinkInterface iface : this.findMatching(builder.toCriteria())) {
            iface.setStatus(action);
            this.saveOrUpdate(iface);
        }
    }

    public void setStatusForNodeAndIfIndex(Integer nodeid, Integer ifIndex, OnmsArpInterface.StatusType action) {
        this.setStatusForNodeAndIfIndex(nodeid, ifIndex, null, action);
    }

    public void setStatusForNodeAndIfIndex(Integer nodeid, Integer ifIndex, String source, OnmsArpInterface.StatusType action) {
        CriteriaBuilder builder = new CriteriaBuilder(DataLinkInterface.class);
        builder.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        if (source != null) {
            builder.eq("source", (Object)source);
        }
        builder.or((Restriction)new AllRestriction(new Restriction[]{new EqRestriction("node.id", (Object)nodeid), new EqRestriction("ifIndex", (Object)ifIndex)}), (Restriction)new AllRestriction(new Restriction[]{new EqRestriction("nodeParentId", (Object)nodeid), new EqRestriction("parentIfIndex", (Object)ifIndex)}));
        for (DataLinkInterface iface : this.findMatching(builder.toCriteria())) {
            iface.setStatus(action);
            this.saveOrUpdate(iface);
        }
    }
}

