/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.opennmsDataSources.DataSourceConfiguration;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class DatabaseChecker {
    private String m_driverUrl;
    private String m_driverUser;
    private String m_driverPass;

    protected DatabaseChecker(String configFile) throws IOException, MarshalException, ValidationException, ClassNotFoundException {
        DataSourceConfiguration m_database = (DataSourceConfiguration)CastorUtils.unmarshal(DataSourceConfiguration.class, (Resource)new FileSystemResource(configFile));
        for (JdbcDataSource jdbcDataSource : m_database.getJdbcDataSourceCollection()) {
            this.m_driverUrl = jdbcDataSource.getUrl();
            this.m_driverUser = jdbcDataSource.getUserName();
            this.m_driverPass = jdbcDataSource.getPassword();
            Class.forName(jdbcDataSource.getClassName());
        }
    }

    protected DatabaseChecker() throws IOException, MarshalException, ValidationException, ClassNotFoundException {
        this(ConfigFileConstants.getFile((int)ConfigFileConstants.OPENNMS_DATASOURCE_CONFIG_FILE_NAME).getPath());
    }

    public void check() throws SQLException {
        Connection c = DriverManager.getConnection(this.m_driverUrl, this.m_driverUser, this.m_driverPass);
        c.close();
    }

    public static void main(String[] argv) throws Exception {
        DatabaseChecker checker = new DatabaseChecker();
        checker.check();
    }
}

