/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.daemon;

import java.lang.reflect.UndeclaredThrowableException;
import org.apache.log4j.Category;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.daemon.BaseOnmsMBean;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSpringContextJmxServiceDaemon<T extends SpringServiceDaemon>
implements BaseOnmsMBean {
    public static final String DAEMON_BEAN_NAME = "daemon";
    private ClassPathXmlApplicationContext m_context;
    private int m_status = 0;

    protected abstract String getSpringContext();

    protected abstract String getLoggingPrefix();

    protected ApplicationContext getContext() {
        return this.m_context;
    }

    @Override
    public final void init() {
        this.setLoggingCategory();
        this.log().debug((Object)("SPRING: thread.classLoader=" + Thread.currentThread().getContextClassLoader()));
        this.m_context = (ClassPathXmlApplicationContext)BeanUtils.getFactory((String)this.getSpringContext(), ClassPathXmlApplicationContext.class);
        this.log().debug((Object)("SPRING: context.classLoader= " + this.m_context.getClassLoader()));
    }

    @Override
    public final void start() {
        this.setLoggingCategory();
        this.setStatus(1);
        T daemon = this.getDaemon();
        try {
            daemon.start();
        }
        catch (Throwable t) {
            this.log().error((Object)("Could not start daemon: " + t), t);
            try {
                this.stop();
            }
            catch (Throwable tt) {
                this.log().error((Object)("Could not stop daemon after it failed to start: " + tt), tt);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
        this.setStatus(2);
    }

    public T getDaemon() {
        return (T)((SpringServiceDaemon)this.m_context.getBean(DAEMON_BEAN_NAME, SpringServiceDaemon.class));
    }

    @Override
    public final void stop() {
        this.setLoggingCategory();
        this.setStatus(3);
        this.m_context.close();
        this.setStatus(4);
    }

    @Override
    public final int getStatus() {
        return this.m_status;
    }

    private void setStatus(int status) {
        this.m_status = status;
    }

    @Override
    public final String status() {
        this.setLoggingCategory();
        return Fiber.STATUS_NAMES[this.getStatus()];
    }

    @Override
    public final String getStatusText() {
        return this.status();
    }

    private Category log() {
        return ThreadCategory.getInstance();
    }

    private void setLoggingCategory() {
        ThreadCategory.setPrefix((String)this.getLoggingPrefix());
    }
}

