<%--

//
// This file is part of the OpenNMS(R) Application.
//
// OpenNMS(R) is Copyright (C) 2002-2003 The OpenNMS Group, Inc.  All rights reserved.
// OpenNMS(R) is a derivative work, containing both original code, included code and modified
// code that was published under the GNU General Public License. Copyrights for modified 
// and included code are below.
//
// OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
//
// Modifications:
//
// 2003 Feb 07: Fixed URLEncoder issues.
// 2002 Nov 26: Fixed breadcrumbs issue.
// 
// Original code base Copyright (C) 1999-2001 Oculan Corp.  All rights reserved.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// For more information contact:
//      OpenNMS Licensing       <license@opennms.org>
//      http://www.opennms.org/
//      http://www.opennms.com/
//

--%>

<%@page language="java"
	contentType="text/html"
	session="true"
	import="org.opennms.web.vulnerability.*,
		java.util.*,
		java.text.*,
		java.sql.SQLException,
		org.opennms.web.acegisecurity.Authentication,
		org.opennms.web.vulnerability.filter.*,
		org.opennms.web.Util,
		org.opennms.web.element.ElementUtil
	"
%>

<%--
  This page is written to be the display (view) portion of the VulnerabilityQueryServlet
  at the /vulnerability/list URL.  It will not work by itself, as it requires two request
  attributes be set:
  
  1) vuls: the list of org.opennms.web.vulnerability.Vulnerability instances to display
  2) parms: an org.opennms.web.vulnerability.VulnerabilityQueryParms object that holds all the 
     parameters used to make this query
--%>

<%!
    //useful constant strings
    public static final String ZOOM_IN_ICON = "[+]";
    public static final String DISCARD_ICON = "[-]";
    public static final String BEFORE_ICON  = "[&gt;]";
    public static final String AFTER_ICON   = "[&lt;]";
    
    public static final DateFormat DATE_FORMAT =
	DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.MEDIUM);
%>

<%
    //required attributes vuls & parms
    Vulnerability[] vuls = (Vulnerability[])request.getAttribute( "vuls" );
    VulnerabilityQueryParms parms = (VulnerabilityQueryParms)request.getAttribute( "parms" );

    if( vuls == null || parms == null ) {
        throw new ServletException( "Missing either the vuls or parms request attribute." );
    }
     
    int vulCount = VulnerabilityFactory.getVulnerabilityCount( parms.resType, parms.getFilters() );            
%>

<jsp:include page="/includes/header.jsp" flush="false" >
  <jsp:param name="title" value="Vulnerability List" />
  <jsp:param name="headTitle" value="List" />
  <jsp:param name="headTitle" value="Vulnerabilities" />
  <jsp:param name="breadcrumb" value="<a href='vulnerability/index.jsp' title='Vulnerabilities System Page'>Vulnerabilities</a>" />
  <jsp:param name="breadcrumb" value="List" />
</jsp:include>

 <!-- menu -->
      <div id="linkbar">
      <ul>
        <li><a href="<%=VulnerabilityUtil.makeLink( request, parms, new ArrayList())%>" title="Remove all search constraints" >View All Vulnerabilities</a></li>

      </ul>
      </div>
      <!-- end menu -->

       <% if( vulCount > 0 ) { %>
              <% String baseUrl = VulnerabilityUtil.makeLink(request,parms); %>
              <jsp:include page="/includes/resultsIndex.jsp" flush="false" >
                <jsp:param name="count"    value="<%=vulCount%>" />
                <jsp:param name="baseurl"  value="<%=baseUrl%>"    />
                <jsp:param name="limit"    value="<%=parms.limit%>"      />
                <jsp:param name="multiple" value="<%=parms.multiple%>"   />
              </jsp:include>
        <% } %>

 	<jsp:include page="/includes/key.jsp" flush="false" />
      
      <!-- Body -->
      <table>
	<thead>
        <!-- List Header Row -->
        <tr>

          <th width="5%"> <%=this.makeSortLink(request, parms, VulnerabilityFactory.SortStyle.ID, VulnerabilityFactory.SortStyle.REVERSE_ID, "id", "ID")%></th>
          <th width="10%"><%=this.makeSortLink(request, parms, VulnerabilityFactory.SortStyle.SEVERITY, VulnerabilityFactory.SortStyle.REVERSE_SEVERITY, "severity", "Severity")%></th>
          <th width="20%"><%=this.makeSortLink(request, parms, VulnerabilityFactory.SortStyle.NODE, VulnerabilityFactory.SortStyle.REVERSE_NODE, "node", "Node")%></th>
          <th width="20%"><%=this.makeSortLink(request, parms, VulnerabilityFactory.SortStyle.INTERFACE, VulnerabilityFactory.SortStyle.REVERSE_INTERFACE, "interface", "Interface")%></th>
          <th width="2%"> <%=this.makeSortLink(request, parms, VulnerabilityFactory.SortStyle.PORT, VulnerabilityFactory.SortStyle.REVERSE_PORT, "port", "Port")%></th>
          <th width="3%"> <%=this.makeSortLink(request, parms, VulnerabilityFactory.SortStyle.PROTOCOL, VulnerabilityFactory.SortStyle.REVERSE_PROTOCOL, "protocol", "Protocol")%></th>
          <th width="20%"><%=this.makeSortLink(request, parms, VulnerabilityFactory.SortStyle.CREATE_TIME, VulnerabilityFactory.SortStyle.REVERSE_CREATE_TIME, "discovery time", "Discovered")%></th>
          <th width="20%"><%=this.makeSortLink(request, parms, VulnerabilityFactory.SortStyle.RESOLVED_TIME, VulnerabilityFactory.SortStyle.REVERSE_RESOLVED_TIME, "resolution time", "Resolved")%></th>
        </tr>
                  
        <% for( int i=0; i < vuls.length; i++ ) { %>
          <tr valign="top" class="<%=VulnerabilityUtil.getSeverityLabel(vuls[i].getSeverity())%> ">                    
            <!-- vulnerability id -->              
            <td class="divider" rowspan="2" >
              <a href="vulnerability/detail.jsp?id=<%=vuls[i].getId()%>"><%=vuls[i].getId()%></a>
            </td>

            <!-- severity -->
            <td class="divider bright" rowspan="2" ">
              <%=VulnerabilityUtil.getSeverityLabel(vuls[i].getSeverity())%>
              
              <% org.opennms.web.vulnerability.filter.Filter severityFilter = new SeverityFilter(vuls[i].getSeverity()); %>            
              <% if( !parms.filters.contains( severityFilter )) { %>
                <nobr>
                  <a href="<%=VulnerabilityUtil.makeLink( request, parms, severityFilter, true)%>" title="Show only vulnerabilities with this severity"><%=ZOOM_IN_ICON%></a>
                  <a href="<%=VulnerabilityUtil.makeLink( request, parms, new NegativeSeverityFilter(vuls[i].getSeverity()), true)%>" title="Do not show vulnerabilities with this severity"><%=DISCARD_ICON%></a>              
                </nobr>
              <% } else { %>            
                &nbsp;
              <% } %>            
            </td>              
            
            <!-- node -->
            <td class="divider">
              <% if(vuls[i].getNodeId() != null ) { %>             
                <% String longLabel  = vuls[i].getNodeLabel(); %>
                <% String shortLabel = ElementUtil.truncateLabel(longLabel, 22); %>
                <a href="element/node.jsp?node=<%=vuls[i].getNodeId()%>" title="<%=longLabel%>"><%=shortLabel%></a>
                
                <% if(vuls[i].getNodeId() != null ) { %>
                  <% org.opennms.web.vulnerability.filter.Filter nodeFilter = new NodeFilter(vuls[i].getNodeId().intValue()); %>
  
                  <% if( !parms.filters.contains(nodeFilter) ) { %>
                    <nobr>
                      <a href="<%=VulnerabilityUtil.makeLink( request, parms, nodeFilter, true)%>" title="Show only vulnerabilities on this node"><%=ZOOM_IN_ICON%></a>
                      <a href="<%=VulnerabilityUtil.makeLink( request, parms, new NegativeNodeFilter(vuls[i].getNodeId().intValue()), true)%>" title="Do not show vulnerabilities for this node"><%=DISCARD_ICON%></a>              
                    </nobr>
                  <% } else { %>                        
                    &nbsp;
                  <% } %>                
                <% } else { %>
                  &nbsp;
                <% } %>                            
              <% } else { %>
                &nbsp;
              <% } %>
            </td>             
            
            <!-- ip addr -->
            <td class="divider">
              <% if(vuls[i].getIpAddress() != null ) { %>
                <% if( vuls[i].getNodeId() != null ) { %>
                   <a href="element/interface.jsp?node=<%=vuls[i].getNodeId()%>&intf=<%=vuls[i].getIpAddress()%>" title="More info on this interface"><%=vuls[i].getIpAddress()%></a>
                <% } else { %>
                   <%=vuls[i].getIpAddress()%>
                <% } %>
                
                <% if(vuls[i].getIpAddress() != null ) { %>
                  <% org.opennms.web.vulnerability.filter.Filter intfFilter = new InterfaceFilter(vuls[i].getIpAddress()); %>
  
                  <% if( !parms.filters.contains(intfFilter) ) { %>
                    <nobr>
                      <a href="<%=VulnerabilityUtil.makeLink( request, parms, intfFilter, true)%>" title="Show only vulnerabilities on this IP address"><%=ZOOM_IN_ICON%></a>
                      <a href="<%=VulnerabilityUtil.makeLink( request, parms, new NegativeInterfaceFilter(vuls[i].getIpAddress()), true)%>" title="Do not show vulnerabilities for this interface"><%=DISCARD_ICON%></a>                                            
                    </nobr>
                  <% } else { %>            
                    &nbsp;
                  <% } %>                
                <% } else { %>
                  &nbsp;
                <% } %>                
              <% } else { %>
                &nbsp;
              <% } %>
            </td>              

            <!-- port -->
            <td class="divider">
              <% if(vuls[i].getPort() != null) { %>
                <%=vuls[i].getPort()%>
                
                <% if(vuls[i].getPort() != null ) { %>
                  <% org.opennms.web.vulnerability.filter.Filter portFilter = new PortFilter(vuls[i].getPort().intValue()); %>
  
                  <% if( !parms.filters.contains(portFilter) ) { %>
                    <nobr>
                      <a href="<%=VulnerabilityUtil.makeLink( request, parms, portFilter, true)%>" title="Show only vulnerabilities on this port"><%=ZOOM_IN_ICON%></a>
                      <a href="<%=VulnerabilityUtil.makeLink( request, parms, new NegativePortFilter(vuls[i].getPort().intValue()), true)%>" title="Do not show vulnerabilities for this port"><%=DISCARD_ICON%></a>                                            
                    </nobr>
                  <% } else { %>            
                    &nbsp;
                  <% } %>                
                <% } else { %>
                  &nbsp;
                <% } %>                
              <% } else { %>
                &nbsp;
              <% } %>
            </td>              

            <!-- protocol -->
            <td class="divider">
              <% if(vuls[i].getProtocol() != null) { %>
                <%=vuls[i].getProtocol()%>
                
                <% if(vuls[i].getProtocol() != null ) { %>
                  <% org.opennms.web.vulnerability.filter.Filter protocolFilter = new ProtocolFilter(vuls[i].getProtocol()); %>
  
                  <% if( !parms.filters.contains(protocolFilter) ) { %>
                    <nobr>
                      <a href="<%=VulnerabilityUtil.makeLink( request, parms, protocolFilter, true)%>" title="Show only vulnerabilities on this protocol"><%=ZOOM_IN_ICON%></a>
                      <a href="<%=VulnerabilityUtil.makeLink( request, parms, new NegativeProtocolFilter(vuls[i].getProtocol()), true)%>" title="Do not show vulnerabilities for this protocol"><%=DISCARD_ICON%></a>                                            
                    </nobr>
                  <% } else { %>            
                    &nbsp;
                  <% } %>                
                <% } else { %>
                  &nbsp;
                <% } %>                
              <% } else { %>
                &nbsp;
              <% } %>
            </td>              
            
            <!-- create time -->
            <td class="divider">
              <nobr><%=DATE_FORMAT.format(vuls[i].getCreateTime())%></nobr>
              
              <nobr>
                <a href="<%=VulnerabilityUtil.makeLink( request, parms, new CreationDateAfterFilter(vuls[i].getCreateTime()), true)%>" title="Only show vulnerabilities created after this one"><%=AFTER_ICON%></a>            
                <a href="<%=VulnerabilityUtil.makeLink( request, parms, new CreationDateBeforeFilter(vuls[i].getCreateTime()), true)%>" title="Only show vulnerabilities created before this one"><%=BEFORE_ICON%></a>            
              </nobr>              
            </td>              
            
            <!-- resolution time -->
            <td class="divider">
		<% if (vuls[i].getResolvedTime() != null) { %>
                <nobr><%=DATE_FORMAT.format(vuls[i].getResolvedTime())%></nobr>
                  <nobr>
                  <a href="<%=VulnerabilityUtil.makeLink( request, parms, new ResolvedDateAfterFilter(vuls[i].getResolvedTime()), true)%>" title="Only show vulnerabilities resolved after this one"><%=AFTER_ICON%></a>
                  <a href="<%=VulnerabilityUtil.makeLink( request, parms, new ResolvedDateBeforeFilter(vuls[i].getResolvedTime()), true)%>" title="Only show vulnerabilities resolved before this one"><%=BEFORE_ICON%></a>
                  </nobr>
		<% } else {%>
		<nobr>&nbsp;</nobr>
		<% } %>
            </td>                            
          </tr>
          
          <!-- log message -->
          <tr  class="<%=VulnerabilityUtil.getSeverityLabel(vuls[i].getSeverity())%>">
            <td  colspan="6">
              <%=vuls[i].getLogMessage()%>
            </td>
          </tr>
         
        <% } /*end for*/%>

      </table>
    
    
<jsp:include page="/includes/bookmark.jsp" flush="false" />

<jsp:include page="/includes/footer.jsp" flush="false" />


<%!
    protected String makeSortLink( HttpServletRequest request, VulnerabilityQueryParms parms, VulnerabilityFactory.SortStyle style, VulnerabilityFactory.SortStyle revStyle, String sortString, String title ) {
        StringBuffer buffer = new StringBuffer();
  
        buffer.append( "<nobr>" );
        
        if( parms.sortStyle == style ) {
            buffer.append( "<a href=\"" );        
            buffer.append( VulnerabilityUtil.makeLink( request, parms, revStyle ));
            buffer.append( "\" title=\"Reverse the sort\">" );            
            buffer.append( "<img src=\"images/arrowdown.gif\" hspace=\"0\" vspace=\"0\" border=\"0\" alt=\"Reverse the sort\"/>" );
            buffer.append( "&nbsp;" );
        } else if( parms.sortStyle == revStyle ) {
            buffer.append( "<a href=\"" );        
            buffer.append( VulnerabilityUtil.makeLink( request, parms, style )); 
            buffer.append( "\" title=\"Reverse the sort\">" );        
            buffer.append( "<img src=\"images/arrowup.gif\" hspace=\"0\" vspace=\"0\" border=\"0\" alt=\"Reverse the sort\"/>" );
            buffer.append( "&nbsp;" );

        } else {
            buffer.append( "<a href=\"" );
            buffer.append( VulnerabilityUtil.makeLink( request, parms, style ));
            buffer.append( "\" title=\"Sort by " );
            buffer.append( sortString );
            buffer.append( "\">" );   
        }
  
        buffer.append( title );
        buffer.append( "</a>" );
        buffer.append( "</nobr>" );
  
        return( buffer.toString() );
    }

%>

