/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.decorators.DefaultToolTipFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.PickableEdgePaintFunction;
import edu.uci.ics.jung.utils.TestGraphs;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.MultiPickedState;
import edu.uci.ics.jung.visualization.PickedState;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.subLayout.CircularSubLayout;
import edu.uci.ics.jung.visualization.subLayout.SubLayoutDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SubLayoutDemo
extends JApplet {
    String instructions = "<html>Use the mouse to select multiple vertices<p>either by dragging a region, or by shift-clicking<p>on multiple vertices.<p>As you select vertices, they become part of a<p>cluster, centered at the location of the first<p>selected vertex.<p>You can drag the cluster with the mouse.<p>Use the 'Picking'/'Transforming' combo-box to switch<p>between picking and transforming mode.</html>";
    Graph graph = TestGraphs.getOneComponentGraph();
    VisualizationViewer vv;
    SubLayoutDecorator clusteringLayout;
    PickedState ps;

    public SubLayoutDemo() {
        PluggableRenderer pr = new PluggableRenderer();
        this.clusteringLayout = new SubLayoutDecorator(new FRLayout(this.graph));
        Dimension preferredSize = new Dimension(400, 400);
        DefaultVisualizationModel visualizationModel = new DefaultVisualizationModel(this.clusteringLayout, preferredSize);
        this.vv = new VisualizationViewer(visualizationModel, (Renderer)pr, preferredSize);
        this.vv.setPickSupport(new ShapePickSupport());
        pr.setEdgeShapeFunction(new EdgeShape.QuadCurve());
        this.vv.setPickedState(new ClusterListener(this.clusteringLayout));
        this.ps = this.vv.getPickedState();
        pr.setEdgePaintFunction(new PickableEdgePaintFunction(this.ps, Color.black, Color.red));
        this.vv.setBackground(Color.white);
        this.vv.setToolTipFunction(new DefaultToolTipFunction());
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        Container content = this.getContentPane();
        GraphZoomScrollPane gzsp = new GraphZoomScrollPane(this.vv);
        content.add(gzsp);
        JComboBox modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(graphMouse.getModeListener());
        graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(SubLayoutDemo.this.vv, 1.1f, SubLayoutDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(SubLayoutDemo.this.vv, 0.9f, SubLayoutDemo.this.vv.getCenter());
            }
        });
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog((JComponent)e.getSource(), SubLayoutDemo.this.instructions, "Help", -1);
            }
        });
        JPanel controls = new JPanel();
        JPanel zoomControls = new JPanel(new GridLayout(2, 1));
        zoomControls.setBorder(BorderFactory.createTitledBorder("Zoom"));
        zoomControls.add(plus);
        zoomControls.add(minus);
        controls.add(zoomControls);
        controls.add(modeBox);
        controls.add(help);
        content.add((Component)controls, "South");
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new SubLayoutDemo());
        f.pack();
        f.show();
    }

    class ClusterListener
    extends MultiPickedState {
        SubLayoutDecorator layout;
        Point2D center;

        public boolean pick(ArchetypeVertex v, boolean picked) {
            boolean result = super.pick(v, picked);
            if (picked) {
                this.vertexPicked(v);
            } else {
                this.vertexUnpicked(v);
            }
            return result;
        }

        public ClusterListener(SubLayoutDecorator layout) {
            this.layout = layout;
        }

        public void vertexPicked(ArchetypeVertex v) {
            if (this.center == null) {
                this.center = this.layout.getLocation(v);
            }
            this.layout.removeAllSubLayouts();
            CircularSubLayout subLayout = new CircularSubLayout(this.getPickedVertices(), 20.0, this.center);
            this.layout.addSubLayout(subLayout);
        }

        public void vertexUnpicked(ArchetypeVertex v) {
            this.layout.removeAllSubLayouts();
            if (!this.getPickedVertices().isEmpty()) {
                CircularSubLayout subLayout = new CircularSubLayout(this.getPickedVertices(), 20.0, this.center);
                this.layout.addSubLayout(subLayout);
            } else {
                this.center = null;
            }
        }
    }
}

