/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.utils;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.ParallelEdgeIndexFunction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DefaultParallelEdgeIndexFunction
implements ParallelEdgeIndexFunction {
    protected Map edge_index = new HashMap();

    private DefaultParallelEdgeIndexFunction() {
    }

    public static DefaultParallelEdgeIndexFunction getInstance() {
        return new DefaultParallelEdgeIndexFunction();
    }

    public int getIndex(Edge e) {
        Integer index = (Integer)this.edge_index.get(e);
        if (index == null) {
            index = this.getIndex_internal(e);
        }
        return index;
    }

    protected Integer getIndex_internal(Edge e) {
        Pair endpoints = e.getEndpoints();
        Vertex u = (Vertex)endpoints.getFirst();
        Vertex v = (Vertex)endpoints.getSecond();
        Set commonEdgeSet = u.findEdgeSet(v);
        int count = 0;
        Iterator iterator = commonEdgeSet.iterator();
        while (iterator.hasNext()) {
            Edge other = (Edge)iterator.next();
            if (e.equals(other)) continue;
            this.edge_index.put(other, new Integer(count));
            ++count;
        }
        Integer index = new Integer(count);
        this.edge_index.put(e, index);
        return index;
    }

    public void reset(Edge e) {
        this.getIndex_internal(e);
    }

    public void reset() {
        this.edge_index.clear();
    }
}

