/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.RelativeAuthorityRanker;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Element;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.MutableDouble;
import edu.uci.ics.jung.utils.UserData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class KStepMarkov
extends RelativeAuthorityRanker {
    public static final String RANK_SCORE = "jung.algorithms.importance.KStepMarkovExperimental.RankScore";
    private static final String CURRENT_RANK = "jung.algorithms.importance.KStepMarkovExperimental.CurrentRank";
    private int mNumSteps;
    HashMap mPreviousRankingsMap;

    public KStepMarkov(DirectedGraph graph, Set priors, int k, String edgeWeightKeyName) {
        super.initialize(graph, true, false);
        this.mNumSteps = k;
        this.setPriors(priors);
        this.initializeRankings();
        if (edgeWeightKeyName == null) {
            this.assignDefaultEdgeTransitionWeights();
        } else {
            this.setUserDefinedEdgeWeightKey(edgeWeightKeyName);
        }
        this.normalizeEdgeTransitionWeights();
    }

    public String getRankScoreKey() {
        return RANK_SCORE;
    }

    protected void incrementRankScore(Element v, double rankValue) {
        MutableDouble value = (MutableDouble)v.getUserDatum(RANK_SCORE);
        value.add(rankValue);
    }

    protected double getCurrentRankScore(Element v) {
        return ((MutableDouble)v.getUserDatum(CURRENT_RANK)).doubleValue();
    }

    protected void setCurrentRankScore(Element v, double rankValue) {
        MutableDouble value = (MutableDouble)v.getUserDatum(CURRENT_RANK);
        if (value == null) {
            v.setUserDatum(CURRENT_RANK, new MutableDouble(rankValue), UserData.SHARED);
        } else {
            value.setDoubleValue(rankValue);
        }
    }

    protected void initializeRankings() {
        this.mPreviousRankingsMap = new HashMap();
        Iterator vIt = this.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex currentVertex = (Vertex)vIt.next();
            Set priors = this.getPriors();
            double numPriors = priors.size();
            if (this.getPriors().contains(currentVertex)) {
                this.setRankScore(currentVertex, 1.0 / numPriors);
                this.setCurrentRankScore(currentVertex, 1.0 / numPriors);
                this.mPreviousRankingsMap.put(currentVertex, new MutableDouble(1.0 / numPriors));
                continue;
            }
            this.setRankScore(currentVertex, 0.0);
            this.setCurrentRankScore(currentVertex, 0.0);
            this.mPreviousRankingsMap.put(currentVertex, new MutableDouble(0.0));
        }
    }

    protected double evaluateIteration() {
        for (int i = 0; i < this.mNumSteps; ++i) {
            this.updateRankings();
            Iterator vIt = this.getVertices().iterator();
            while (vIt.hasNext()) {
                Vertex currentVertex = (Vertex)vIt.next();
                double currentRankScore = this.getCurrentRankScore(currentVertex);
                MutableDouble previousRankScore = (MutableDouble)this.mPreviousRankingsMap.get(currentVertex);
                this.incrementRankScore(currentVertex, currentRankScore);
                previousRankScore.setDoubleValue(currentRankScore);
            }
        }
        this.normalizeRankings();
        return 0.0;
    }

    protected void onFinalize(Element udc) {
        udc.removeUserDatum(CURRENT_RANK);
    }

    protected void updateRankings() {
        Iterator vIt = this.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex currentVertex = (Vertex)vIt.next();
            Set incomingEdges = currentVertex.getInEdges();
            double currentPageRankSum = 0.0;
            Iterator edgeIt = incomingEdges.iterator();
            while (edgeIt.hasNext()) {
                Edge incomingEdge = (Edge)edgeIt.next();
                double currentWeight = this.getEdgeWeight(incomingEdge);
                currentPageRankSum += ((MutableDouble)this.mPreviousRankingsMap.get(incomingEdge.getOpposite(currentVertex))).doubleValue() * currentWeight;
            }
            this.setCurrentRankScore(currentVertex, currentPageRankSum);
        }
    }
}

