/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ping;

import java.net.DatagramPacket;
import org.apache.log4j.Category;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ping.Reply;
import org.opennms.protocols.icmp.IcmpSocket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReplyReceiver
implements PausableFiber,
Runnable {
    private static final String NAME = "ICMPReceiver";
    private FifoQueue<Reply> m_replyQ;
    private IcmpSocket m_portal;
    private short m_filterID;
    private volatile boolean m_paused;
    private String m_name;
    private Thread m_worker;
    private int m_status;

    private ReplyReceiver() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("invalid constructor invocation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(DatagramPacket pkt) throws InterruptedException, FifoQueueException {
        boolean doIt = false;
        ReplyReceiver replyReceiver = this;
        synchronized (replyReceiver) {
            doIt = this.m_paused;
        }
        if (!doIt) {
            Reply reply = null;
            try {
                reply = Reply.create(pkt);
            }
            catch (IllegalArgumentException iaE) {
                return;
            }
            catch (IndexOutOfBoundsException iooB) {
                return;
            }
            if (reply.isEchoReply() && reply.getIdentity() == this.m_filterID) {
                this.m_replyQ.add((Object)reply);
            }
        }
    }

    public ReplyReceiver(IcmpSocket portal, FifoQueue<Reply> replyQ, short filterID) {
        this.m_portal = portal;
        this.m_replyQ = replyQ;
        this.m_filterID = filterID;
        this.m_paused = false;
        this.m_name = NAME + (filterID < 0 ? filterID + 65536 : filterID);
        this.m_worker = null;
        this.m_status = 0;
    }

    public final synchronized void start() {
        if (this.m_worker != null) {
            throw new IllegalStateException("The Fiber is already running or has run");
        }
        this.m_status = 1;
        this.m_worker = new Thread((Runnable)this, this.m_name);
        this.m_worker.setDaemon(true);
        this.m_worker.start();
    }

    public final synchronized void stop() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The Fiber has not been started");
        }
        if (this.m_worker.isAlive()) {
            if (this.m_status != 4) {
                this.m_status = 3;
            }
            this.m_worker.interrupt();
        } else {
            this.m_status = 4;
        }
    }

    public final synchronized void pause() {
        if (this.m_worker == null || !this.m_worker.isAlive()) {
            throw new IllegalStateException("The fiber is not running");
        }
        this.m_paused = true;
    }

    public final synchronized void resume() {
        if (this.m_worker == null || !this.m_worker.isAlive()) {
            throw new IllegalStateException("The fiber is not running");
        }
        this.m_paused = false;
    }

    public final String getName() {
        return this.m_name;
    }

    public final synchronized int getStatus() {
        if (this.m_status == 2 && this.m_paused) {
            return 6;
        }
        return this.m_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        ReplyReceiver replyReceiver = this;
        synchronized (replyReceiver) {
            this.m_status = 2;
        }
        try {
            while (true) {
                replyReceiver = this;
                synchronized (replyReceiver) {
                    if (this.m_status == 3) {
                        break;
                    }
                }
                this.process(this.m_portal.receive());
            }
        }
        catch (Exception e) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"run: an exception occured processing the datagram, thread exiting");
            }
            return;
        }
        finally {
            ReplyReceiver replyReceiver2 = this;
            synchronized (replyReceiver2) {
                this.m_status = 4;
            }
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

