/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDataSource
implements DataSource {
    private String m_driver;
    private String m_url;
    private String m_user;
    private String m_password;
    private Integer m_timeout = null;

    public SimpleDataSource(String driver, String url, String user, String password) throws ClassNotFoundException {
        this.m_driver = driver;
        this.m_url = url;
        this.m_user = user;
        this.m_password = password;
        Class.forName(this.m_driver);
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.m_timeout == null) {
            return DriverManager.getConnection(this.m_url, this.m_user, this.m_password);
        }
        int oldTimeout = DriverManager.getLoginTimeout();
        DriverManager.setLoginTimeout(this.m_timeout);
        Connection conn = DriverManager.getConnection(this.m_url, this.m_user, this.m_password);
        DriverManager.setLoginTimeout(oldTimeout);
        return conn;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("getConnection(String, String) not implemented");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new UnsupportedOperationException("getLogWriter() not implemented");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_timeout == null ? -1 : this.m_timeout;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new UnsupportedOperationException("setLogWriter(PrintWriter) not implemented");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_timeout = seconds;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

