/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Column {
    private String m_name = null;
    private String m_type = null;
    private int m_size = 0;
    private boolean m_notNull = false;
    private String m_defaultValue = null;

    public boolean equals(Object other_o) {
        Column other = (Column)other_o;
        if (this.m_name == null && other.getName() != null || this.m_name != null && other.getName() == null) {
            return false;
        }
        if (this.m_name != null && other.getName() != null && !this.m_name.equals(other.getName())) {
            return false;
        }
        if (this.m_type == null && other.getType() != null || this.m_type != null && other.getType() == null) {
            return false;
        }
        if (this.m_type != null && other.getType() != null && !this.m_type.equals(other.getType())) {
            return false;
        }
        if (this.m_size != other.getSize()) {
            return false;
        }
        if (this.m_notNull != other.isNotNull()) {
            return false;
        }
        if (this.m_defaultValue == null && other.getDefaultValue() != null || this.m_defaultValue != null && other.getDefaultValue() == null) {
            return false;
        }
        return this.m_defaultValue == null || other.getDefaultValue() == null || this.m_defaultValue.equals(other.getDefaultValue());
    }

    public int hashCode() {
        return this.m_name.hashCode() + this.m_type.hashCode() + new Integer(this.m_size).hashCode() + new Boolean(this.m_notNull).hashCode();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.m_name);
        b.append(" ");
        b.append(this.m_type);
        if (this.m_size > 0) {
            b.append("(");
            b.append(Integer.toString(this.m_size));
            if (this.m_type.equals("numeric")) {
                b.append(",2");
            }
            b.append(")");
        }
        if (this.hasDefaultValue()) {
            b.append(" DEFAULT " + this.getDefaultValue());
        }
        if (this.m_notNull) {
            b.append(" NOT NULL");
        }
        return b.toString();
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name.toLowerCase();
    }

    public boolean isNotNull() {
        return this.m_notNull;
    }

    public void setNotNull(boolean notNull) {
        this.m_notNull = notNull;
    }

    public int getSize() {
        return this.m_size;
    }

    public void setSize(int size) {
        this.m_size = size;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.m_defaultValue != null;
    }

    public void setDefaultValue(String defaultValue) {
        this.m_defaultValue = defaultValue != null && defaultValue.matches("nextval\\('[^']+'\\)") ? defaultValue.toLowerCase() : defaultValue;
    }

    public void parse(String column) throws Exception {
        Matcher m = Pattern.compile("(?i)(.*)\\bnot null\\b(.*)").matcher(column);
        if (m.matches()) {
            this.m_notNull = true;
            column = m.group(1) + m.group(2);
        }
        column = column.trim().replaceAll("\\s+", " ");
        m = Pattern.compile("(?i)(.*?)\\s*\\bdefault (.+)").matcher(column);
        if (m.matches()) {
            column = m.group(1);
            this.setDefaultValue(m.group(2));
        }
        String col_name = null;
        m = Pattern.compile("(\\S+)\\s+(.+)").matcher(column);
        if (!m.matches()) {
            throw new Exception("cannot parse column: " + column);
        }
        col_name = m.group(1).replaceAll("^['\"]", "").replaceAll("['\"]$", "");
        String col_type = m.group(2).replaceAll("^['\"]", "").replaceAll("['\"]$", "");
        this.setName(col_name);
        this.parseColumnType(col_type.trim().toLowerCase());
    }

    public void parseColumnType(String columnType) throws Exception {
        String type;
        String size = null;
        int start = columnType.indexOf(40);
        int end = columnType.indexOf(41);
        if (start != -1 && end != -1) {
            type = columnType.substring(0, start);
            size = columnType.substring(start + 1, end).replaceAll(",\\d+", "");
        } else {
            type = columnType;
        }
        this.setType(Column.normalizeColumnType(type, size != null));
        if (size != null) {
            this.setSize(Integer.parseInt(size));
        } else {
            try {
                this.setSize(this.columnTypeSize(this.getType()));
            }
            catch (Exception e) {
                throw new Exception("Could not determine size for column " + this.getName() + ".  Chained: " + e.getMessage(), e);
            }
        }
    }

    public int getColumnSqlType() throws Exception {
        if (this.m_type.equals("integer")) {
            return 4;
        }
        if (this.m_type.equals("smallint")) {
            return 5;
        }
        if (this.m_type.equals("bigint")) {
            return -5;
        }
        if (this.m_type.equals("real")) {
            return 7;
        }
        if (this.m_type.equals("double precision")) {
            return 8;
        }
        if (this.m_type.equals("boolean")) {
            return 16;
        }
        if (this.m_type.equals("character")) {
            return 1;
        }
        if (this.m_type.equals("character varying")) {
            return 12;
        }
        if (this.m_type.equals("bpchar")) {
            return 12;
        }
        if (this.m_type.equals("numeric")) {
            return 2;
        }
        if (this.m_type.equals("text")) {
            return -1;
        }
        if (this.m_type.equals("timestamp")) {
            return 93;
        }
        if (this.m_type.equals("timestamptz")) {
            return 93;
        }
        if (this.m_type.equals("bytea")) {
            return -3;
        }
        throw new Exception("Do not have a Java SQL type for \"" + this.m_type + "\"");
    }

    public static String normalizeColumnType(String column, boolean hasSize) throws Exception {
        if (column.equals("integer") || column.equals("int4")) {
            return "integer";
        }
        if (column.equals("float") || column.equals("float8") || column.equals("double precision") || column.equals("double")) {
            return "double precision";
        }
        if (column.equals("float4") || column.equals("real")) {
            return "real";
        }
        if (column.equals("bigint") || column.equals("int8")) {
            return "bigint";
        }
        if (column.equals("int2") || column.equals("smallint")) {
            return "smallint";
        }
        if (column.equals("bool") || column.equals("boolean")) {
            return "boolean";
        }
        if (column.equals("character") && !hasSize) {
            return "character";
        }
        if (column.equals("varchar") || column.equals("character varying")) {
            return "character varying";
        }
        if ((column.equals("char") || column.equals("character") || column.equals("bpchar")) && hasSize) {
            return "bpchar";
        }
        if (column.equals("numeric")) {
            return "numeric";
        }
        if (column.equals("text")) {
            return "text";
        }
        if (column.equals("trigger")) {
            return "trigger";
        }
        if (column.equals("timestamp") || column.equals("timestamp without time zone")) {
            return "timestamp";
        }
        if (column.equals("timestamptz") || column.equals("timestamp with time zone")) {
            return "timestamptz";
        }
        if (column.equals("bytea")) {
            return "bytea";
        }
        throw new Exception("cannot parse column type: '" + column + "'");
    }

    public int columnTypeSize(String type) throws Exception {
        if (type.equals("boolean") || type.equals("character")) {
            return 1;
        }
        if (type.equals("smallint")) {
            return 2;
        }
        if (type.equals("integer")) {
            return 4;
        }
        if (type.equals("bigint") || type.equals("timestamp") || type.equals("timestamptz")) {
            return 8;
        }
        if (type.equals("double precision") || type.equals("real") || type.equals("text") || type.equals("bytea") || type.equals("trigger")) {
            return -1;
        }
        throw new Exception("do not know the type size for column type \"" + type + "\"");
    }
}

