/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.engines.activescript;

import com.ibm.bsf.BSFDeclaredBean;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.engines.activescript.COMIDispatchBean;
import com.ibm.bsf.engines.activescript.JavaBean;
import com.ibm.bsf.engines.activescript.JavaBeanAddEventListener;
import com.ibm.bsf.engines.activescript.vbEmpty;
import com.ibm.bsf.util.BSFEngineImpl;
import com.ibm.bsf.util.EngineUtils;
import java.util.Hashtable;
import java.util.Vector;

public class ActiveScriptEngine
extends BSFEngineImpl
implements JavaBeanAddEventListener {
    static BSFException dllLoadException = null;
    static final String libName = "bsfactivescriptengine";
    static final String LANG_VBSCRIPT = "vbscript";
    static final String LANG_PERLSCRIPT = "perlscript";
    static final String LANG_JSCRIPT = "jscript";
    byte[] css = null;
    BSFManager bsfmgr = null;
    private Hashtable evalRet = null;
    protected String lang = null;

    protected final boolean isVBScript() {
        return this.lang.equalsIgnoreCase(LANG_VBSCRIPT);
    }

    protected final boolean isPerlScript() {
        return this.lang.equalsIgnoreCase(LANG_PERLSCRIPT);
    }

    protected final boolean isJScript() {
        return this.lang.equalsIgnoreCase(LANG_JSCRIPT);
    }

    protected final boolean isCaseSensitive() {
        return this.isVBScript();
    }

    public final void setEvalRet(Object object) {
        this.evalRet.put(new Integer(Thread.currentThread().hashCode()), object != null ? object : this.evalRet);
    }

    private final boolean terminated() {
        return null == this.css;
    }

    private native void nativeInit(String var1, String var2, Object[] var3) throws BSFException;

    private native Object nativeEval(byte[] var1, String var2, int var3, int var4, String var5, boolean var6) throws BSFException;

    private native void nativeTerminate(byte[] var1);

    private native byte[] nativeObjectToVariant(byte[] var1, Object var2) throws BSFException;

    private native byte[] nativeStingToBString(String var1) throws BSFException;

    static native void nativeIdispatchAddRef(byte[] var0) throws BSFException;

    static native void nativeIdispatchDeleteRef(byte[] var0) throws BSFException;

    public void initialize(BSFManager bSFManager, String string, Vector vector) throws BSFException {
        if (null != dllLoadException) {
            throw dllLoadException;
        }
        ActiveScriptEngine activeScriptEngine = this;
        synchronized (activeScriptEngine) {
            if (null != this.lang) {
                this.lang = string;
                throw new BSFException(BSFException.REASON_OTHER_ERROR, "Engine " + this + " initialized again");
            }
            this.lang = string;
        }
        super.initialize(bSFManager, string, vector);
        if (this.isPerlScript()) {
            this.evalRet = new Hashtable();
        }
        this.bsfmgr = bSFManager;
        this.nativeInit(this.lang, null, null);
        if (this.css == null) {
            throw new BSFException(BSFException.REASON_OTHER_ERROR, "Engine " + this + " failed to initialize native interface properly.");
        }
        if (0 != vector.size()) {
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            if (this.isVBScript()) {
                string2 = "SET ";
                string3 = "=bsf.lookupBean(\"";
                string4 = "\")";
                string5 = ":";
                string6 = "";
            } else if (this.isJScript()) {
                string2 = "var ";
                string3 = "=bsf.lookupBean(\"";
                string4 = "\")";
                string6 = string5 = ";";
            } else if (this.isPerlScript()) {
                string2 = "$";
                string3 = "=$bsf->lookupBean('";
                string4 = "')";
                string6 = string5 = ";";
            } else {
                throw new BSFException(BSFException.REASON_OTHER_ERROR, this.lang + " does not support undeclareBean.");
            }
            StringBuffer stringBuffer = new StringBuffer("");
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                BSFDeclaredBean bSFDeclaredBean = (BSFDeclaredBean)vector.elementAt(n2);
                if (this.isVBScript()) {
                    string2 = bSFDeclaredBean.bean instanceof String ? "" : "SET ";
                }
                stringBuffer.append(string2 + bSFDeclaredBean.name + string3 + bSFDeclaredBean.name + string4 + (n2 < n - 1 ? string5 : string6));
                ++n2;
            }
            this.exec("<declareBean>", 0, 0, stringBuffer.toString());
        }
    }

    public void exec(String string, int n, int n2, Object object) throws BSFException {
        ActiveScriptEngine activeScriptEngine = this;
        synchronized (activeScriptEngine) {
            if (this.terminated()) {
                throw new BSFException(BSFException.REASON_OTHER_ERROR, "Exec or eval called after engine termination!");
            }
        }
        this.nativeEval(this.css, string, n, n2, object.toString(), false);
    }

    public Object eval(String string, int n, int n2, Object object) throws BSFException {
        if (!this.isPerlScript()) {
            return this.nativeEval(this.css, string, n, n2, object.toString(), true);
        }
        Integer n3 = new Integer(Thread.currentThread().hashCode());
        this.nativeEval(this.css, "<bsf perl declare>", n, n2, "$bsf->setEvalRet(" + object.toString() + "); #via eval", false);
        Object v = this.evalRet.get(n3);
        if (v == this.evalRet) {
            v = null;
        }
        this.evalRet.put(n3, this.evalRet);
        return v;
    }

    public Object call(Object object, String string, Object[] objectArray) throws BSFException {
        if (string == null || string.trim().length() == 0) {
            return new BSFException(BSFException.REASON_OTHER_ERROR, "Invalid method name!");
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        if (null != object && object.toString().trim().length() != 0) {
            if (this.isPerlScript()) {
                stringBuffer.append("$");
            }
            stringBuffer.append(object.toString().trim());
            if (this.isPerlScript()) {
                stringBuffer.append("->");
            } else {
                stringBuffer.append(".");
            }
        }
        stringBuffer.append(string);
        stringBuffer.append("(");
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append(objectArray[n].toString());
                if (n < objectArray.length - 1) {
                    stringBuffer.append(",");
                }
                ++n;
            }
        }
        stringBuffer.append(")");
        return this.eval("<internal>", -1, -1, stringBuffer.toString());
    }

    private final Object callBeanMethod(Object object, String string, Object[] objectArray) throws BSFException {
        if (object.equals(this) && string.equals("callMethodViaBSF")) {
            return this.callMethodViaBSF((Object[])objectArray[0]);
        }
        if (object.equals(this) && string.equals("createBean")) {
            return this.createBean((Object[])objectArray[0]);
        }
        return EngineUtils.callBeanMethod(object, string, objectArray);
    }

    final Object callMethodViaBSF(Object[] objectArray) throws BSFException {
        Object[] objectArray2 = new Object[objectArray.length - 2];
        if (objectArray.length > 2) {
            System.arraycopy(objectArray, 2, objectArray2, 0, objectArray.length - 2);
        }
        return EngineUtils.callBeanMethod(objectArray[0], (String)objectArray[1], objectArray2);
    }

    public final Object createBean(Object[] objectArray) throws BSFException {
        Object[] objectArray2 = new Object[objectArray.length - 1];
        if (objectArray.length > 1) {
            System.arraycopy(objectArray, 1, objectArray2, 0, objectArray.length - 1);
        }
        return EngineUtils.createBean((String)objectArray[0], objectArray2);
    }

    public void addEventListener(Object object, String string, String string2, String string3) throws BSFException {
        EngineUtils.addEventListener(object, string, string2, this, this.bsfmgr, "ActiveScriptEngine", 0, 0, string3);
    }

    public static final Throwable createBSFException(int n, String string, Throwable throwable) {
        if (throwable != null) {
            return new BSFException(n, string, throwable);
        }
        return new BSFException(n, string);
    }

    public final int bindMember(Object object, String string, short s) throws Exception {
        return JavaBean.bindMember(object.getClass(), string, s);
    }

    public final Object callMethod(Object object, int n, Object[] objectArray) throws Exception {
        return JavaBean.callMethod(this, object, n, objectArray);
    }

    public final Object lookupBean(String string) {
        return this.bsfmgr.lookupBean(string);
    }

    public final void declareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        if (this.isVBScript()) {
            this.exec("<declareBean>", 0, 0, (bSFDeclaredBean.bean instanceof String ? "" : "SET ") + bSFDeclaredBean.name + "=bsf.lookupBean(\"" + bSFDeclaredBean.name + "\") 'via declareBean");
        } else if (this.isJScript()) {
            this.exec("<declareBean>", 0, 0, "var " + bSFDeclaredBean.name + "=bsf.lookupBean(\"" + bSFDeclaredBean.name + "\"); //via declareBean");
        } else if (this.isPerlScript()) {
            this.exec("<declareBean>", 0, 0, "$" + bSFDeclaredBean.name + "=$bsf->lookupBean('" + bSFDeclaredBean.name + "'); #via declareBean");
        } else {
            throw new BSFException(BSFException.REASON_OTHER_ERROR, this.lang + " does not support declareBean.");
        }
    }

    public void undeclareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        if (this.isVBScript()) {
            this.exec("<undeclareBean>", 0, 0, (bSFDeclaredBean.bean instanceof String ? "" : "SET ") + bSFDeclaredBean.name + "=Nothing 'via undeclareBean");
        } else if (this.isJScript()) {
            this.exec("<undeclareBean>", 0, 0, bSFDeclaredBean.name + "=null; // via undeclareBean");
        } else if (this.isPerlScript()) {
            this.exec("<undeclareBean>", 0, 0, "undef " + bSFDeclaredBean.name + " ; #via undeclareBean");
        } else {
            throw new BSFException(BSFException.REASON_OTHER_ERROR, this.lang + " does not support undeclareBean.");
        }
    }

    private final byte[] objectToVariant(Object object) throws BSFException {
        byte[] byArray = new byte[16];
        if (null == object) {
            byArray[0] = 1;
            byArray[1] = 0;
        } else if (object instanceof Boolean) {
            int n;
            byArray[0] = 11;
            byArray[1] = 0;
            byArray[8] = n = (Boolean)object != false ? -1 : 0;
            byArray[9] = n;
            byArray[10] = n;
            byArray[11] = n;
        } else if (object instanceof Integer) {
            byArray[0] = 3;
            byArray[1] = 0;
            int n = (Integer)object;
            byArray[8] = (byte)n;
            byArray[9] = (byte)(n >>> 8 & 0xFF);
            byArray[10] = (byte)(n >>> 16 & 0xFF);
            byArray[11] = (byte)(n >>> 24 & 0xFF);
        } else if (object instanceof String) {
            byArray[0] = 8;
            byArray[1] = 0;
        } else if (object instanceof Long) {
            byArray[0] = 5;
            byArray[1] = 0;
            long l = Double.doubleToLongBits(((Long)object).longValue());
            byArray[8] = (byte)l;
            byArray[9] = (byte)(l >>> 8 & 0xFFL);
            byArray[10] = (byte)(l >>> 16 & 0xFFL);
            byArray[11] = (byte)(l >>> 24 & 0xFFL);
            byArray[12] = (byte)(l >>> 32 & 0xFFL);
            byArray[13] = (byte)(l >>> 40 & 0xFFL);
            byArray[14] = (byte)(l >>> 48 & 0xFFL);
            byArray[15] = (byte)(l >>> 56 & 0xFFL);
        } else if (object instanceof Short) {
            byArray[0] = 2;
            byArray[1] = 0;
            int n = ((Short)object).intValue();
            byArray[8] = (byte)n;
            byArray[9] = (byte)(n >>> 8 & 0xFF);
            byArray[10] = (byte)(n >>> 16 & 0xFF);
            byArray[11] = (byte)(n >>> 24 & 0xFF);
        } else if (object instanceof Float) {
            byArray[0] = 4;
            byArray[1] = 0;
            int n = Float.floatToIntBits(((Float)object).floatValue());
            byArray[8] = (byte)n;
            byArray[9] = (byte)(n >>> 8 & 0xFF);
            byArray[10] = (byte)(n >>> 16 & 0xFF);
            byArray[11] = (byte)(n >>> 24 & 0xFF);
        } else if (object instanceof Double) {
            byArray[0] = 5;
            byArray[1] = 0;
            long l = Double.doubleToLongBits((Double)object);
            byArray[8] = (byte)l;
            byArray[9] = (byte)(l >>> 8 & 0xFFL);
            byArray[10] = (byte)(l >>> 16 & 0xFFL);
            byArray[11] = (byte)(l >>> 24 & 0xFFL);
            byArray[12] = (byte)(l >>> 32 & 0xFFL);
            byArray[13] = (byte)(l >>> 40 & 0xFFL);
            byArray[14] = (byte)(l >>> 48 & 0xFFL);
            byArray[15] = (byte)(l >>> 56 & 0xFFL);
        } else if (object instanceof Byte) {
            byte by;
            byArray[0] = 17;
            byArray[1] = 0;
            byArray[8] = by = ((Byte)object).byteValue();
        } else if (object instanceof Character) {
            byte by;
            byArray[0] = 17;
            byArray[1] = 0;
            byArray[8] = by = (byte)((Character)object).charValue();
        } else if (object instanceof Void) {
            byArray[0] = 1;
            byArray[1] = 0;
        } else if (object.getClass().isArray()) {
            ArrayInfo arrayInfo = new ArrayInfo(object);
            byArray = arrayInfo.toVariant();
        } else {
            byArray[0] = 9;
            byArray[1] = 0;
            byte[] byArray2 = null;
            if (object instanceof COMIDispatchBean) {
                byArray2 = ((COMIDispatchBean)object).getIDispatchInterface();
                System.arraycopy(byArray2, 0, byArray, 8, byArray2.length);
            } else if (object instanceof vbEmpty) {
                byArray[0] = 0;
                byArray[1] = 0;
            } else {
                byArray2 = this.nativeObjectToVariant(this.css, object);
                System.arraycopy(byArray2, 0, byArray, 8, byArray2.length);
            }
        }
        return byArray;
    }

    public synchronized void terminate() {
        if (!this.terminated()) {
            byte[] byArray = this.css;
            this.css = null;
            this.bsfmgr = null;
            this.evalRet = null;
            this.lang = null;
            this.nativeTerminate(byArray);
            super.terminate();
        }
    }

    protected void finalize() throws Throwable {
        this.terminate();
        super.finalize();
    }

    static {
        try {
            System.loadLibrary(libName);
        }
        catch (SecurityException securityException) {
            dllLoadException = new BSFException(BSFException.REASON_OTHER_ERROR, "SecurityException loading library:bsfactivescriptengine " + securityException.getMessage(), securityException);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            dllLoadException = new BSFException(BSFException.REASON_OTHER_ERROR, "UnsatisfiedLinkError loading library:bsfactivescriptengine " + unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
        }
    }

    class ArrayInfo {
        protected Object arrayObject = null;
        protected boolean investigated = false;
        public int maxDepth = 0;
        public char type = '\u0000';
        public int[] maxDimArray = null;
        public int[] dimOffset = null;

        public String toString() {
            if (0 == this.maxDepth) {
                return "Not an array";
            }
            String string = "type=" + this.type + ",maxDepth=" + this.maxDepth + "maxDimArray=\n";
            int n = 0;
            while (n < this.maxDepth) {
                string = string + "[" + n + "]" + "=" + this.maxDimArray[n] + ";\n";
                ++n;
            }
            return string;
        }

        protected void investigate(Object object, int n) {
            block26: {
                int n2;
                block25: {
                    if (this.investigated) {
                        return;
                    }
                    if (null == object) {
                        return;
                    }
                    if ((n2 = ++n) != this.maxDepth) break block25;
                    switch (this.type) {
                        case 'Z': {
                            boolean[] blArray = (boolean[])object;
                            if (blArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = blArray.length;
                                break;
                            }
                            break block26;
                        }
                        case 'B': {
                            byte[] byArray = (byte[])object;
                            if (byArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = byArray.length;
                                break;
                            }
                            break block26;
                        }
                        case 'C': {
                            char[] cArray = (char[])object;
                            if (cArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = cArray.length;
                                break;
                            }
                            break block26;
                        }
                        case 'S': {
                            short[] sArray = (short[])object;
                            if (sArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = sArray.length;
                                break;
                            }
                            break block26;
                        }
                        case 'I': {
                            int[] nArray = (int[])object;
                            if (nArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = nArray.length;
                                break;
                            }
                            break block26;
                        }
                        case 'J': {
                            long[] lArray = (long[])object;
                            if (lArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = lArray.length;
                                break;
                            }
                            break block26;
                        }
                        case 'F': {
                            float[] fArray = (float[])object;
                            if (fArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = fArray.length;
                                break;
                            }
                            break block26;
                        }
                        case 'D': {
                            double[] dArray = (double[])object;
                            if (dArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = dArray.length;
                                break;
                            }
                            break block26;
                        }
                        default: {
                            Object[] objectArray = (Object[])object;
                            if (objectArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = objectArray.length;
                                break;
                            }
                            break block26;
                        }
                    }
                    break block26;
                }
                Object[] objectArray = (Object[])object;
                if (objectArray.length > this.maxDimArray[n - 1]) {
                    this.maxDimArray[n - 1] = objectArray.length;
                }
                int n3 = 0;
                while (n3 < objectArray.length) {
                    if (objectArray[n3].getClass().isArray()) {
                        this.investigate(objectArray[n3], n2);
                    }
                    ++n3;
                }
            }
            if (1 == n) {
                this.investigated = true;
            }
        }

        private int setVariantData(Object object, byte[] byArray, int n, int n2, int[] nArray) throws BSFException {
            if (++n2 != this.maxDepth) {
                Object[] objectArray = (Object[])object;
                int n3 = 0;
                while (n3 < objectArray.length) {
                    if (objectArray[n3] != null) {
                        nArray[n2 - 1] = n3;
                        int n4 = n2;
                        while (n4 < this.maxDepth) {
                            nArray[n4++] = 0;
                        }
                        this.setVariantData(objectArray[n3], byArray, n, n2, nArray);
                    }
                    ++n3;
                }
            } else {
                switch (this.type) {
                    case 'Z': {
                        int n5;
                        boolean[] blArray = (boolean[])object;
                        int n6 = n;
                        int n7 = 0;
                        while (n7 < n2 - 1) {
                            n6 += nArray[n7] * this.dimOffset[n7] * 16;
                            ++n7;
                        }
                        int n8 = 0;
                        while (n8 < blArray.length) {
                            int n9;
                            n5 = n6 + n8 * this.dimOffset[n2 - 1] * 16;
                            byArray[n5] = 11;
                            byArray[n5 + 1] = 0;
                            byArray[n5 + 2] = n9 = blArray[n8] ? -1 : 0;
                            byArray[n5 + 3] = n9;
                            byArray[n5 + 4] = n9;
                            byArray[n5 + 5] = n9;
                            ++n8;
                        }
                        while (n8 < this.maxDimArray[n2 - 1]) {
                            n5 = n6 + n8 * this.dimOffset[n2 - 1] * 16;
                            byArray[n5 + 1] = 0;
                            byArray[n5] = 0;
                            ++n8;
                        }
                        break;
                    }
                    case 'B': {
                        int n10;
                        byte[] byArray2 = (byte[])object;
                        int n11 = n;
                        int n12 = 0;
                        while (n12 < n2 - 1) {
                            n11 += nArray[n12] * this.dimOffset[n12] * 16;
                            ++n12;
                        }
                        int n13 = 0;
                        while (n13 < byArray2.length) {
                            n10 = n11 + n13 * this.dimOffset[n2 - 1] * 16;
                            byArray[n10] = 17;
                            byArray[n10 + 1] = 0;
                            byte by = byArray2[n13];
                            byArray[n10 + 8] = by;
                            byArray[n10 + 11] = 0;
                            byArray[n10 + 10] = 0;
                            byArray[n10 + 9] = 0;
                            ++n13;
                        }
                        while (n13 < this.maxDimArray[n2 - 1]) {
                            n10 = n11 + n13 * this.dimOffset[n2 - 1] * 16;
                            byArray[n10 + 1] = 0;
                            byArray[n10] = 0;
                            ++n13;
                        }
                        break;
                    }
                    case 'C': {
                        int n14;
                        char[] cArray = (char[])object;
                        int n15 = n;
                        int n16 = 0;
                        while (n16 < n2 - 1) {
                            n15 += nArray[n16] * this.dimOffset[n16] * 16;
                            ++n16;
                        }
                        int n17 = 0;
                        while (n17 < cArray.length) {
                            byte by;
                            n14 = n15 + n17 * this.dimOffset[n2 - 1] * 16;
                            byArray[n14] = 17;
                            byArray[n14 + 1] = 0;
                            byArray[n14 + 8] = by = (byte)((Character)object).charValue();
                            byArray[n14 + 11] = 0;
                            byArray[n14 + 10] = 0;
                            byArray[n14 + 9] = 0;
                            ++n17;
                        }
                        while (n17 < this.maxDimArray[n2 - 1]) {
                            n14 = n15 + n17 * this.dimOffset[n2 - 1] * 16;
                            byArray[n14 + 1] = 0;
                            byArray[n14] = 0;
                            ++n17;
                        }
                        break;
                    }
                    case 'S': {
                        int n18;
                        short[] sArray = (short[])object;
                        int n19 = n;
                        int n20 = 0;
                        while (n20 < n2 - 1) {
                            n19 += nArray[n20] * this.dimOffset[n20] * 16;
                            ++n20;
                        }
                        int n21 = 0;
                        while (n21 < sArray.length) {
                            n18 = n19 + n21 * this.dimOffset[n2 - 1] * 16;
                            byArray[n18] = 2;
                            byArray[n18 + 1] = 0;
                            short s = sArray[n21];
                            byArray[n18 + 8] = (byte)s;
                            byArray[n18 + 9] = (byte)(s >>> 8 & 0xFF);
                            byArray[n18 + 10] = (byte)(s >>> 16 & 0xFF);
                            byArray[n18 + 11] = (byte)(s >>> 24 & 0xFF);
                            ++n21;
                        }
                        while (n21 < this.maxDimArray[n2 - 1]) {
                            n18 = n19 + n21 * this.dimOffset[n2 - 1] * 16;
                            byArray[n18 + 1] = 0;
                            byArray[n18] = 0;
                            ++n21;
                        }
                        break;
                    }
                    case 'I': {
                        int n22;
                        int[] nArray2 = (int[])object;
                        int n23 = n;
                        int n24 = 0;
                        while (n24 < n2 - 1) {
                            n23 += nArray[n24] * this.dimOffset[n24] * 16;
                            ++n24;
                        }
                        int n25 = 0;
                        while (n25 < nArray2.length) {
                            n22 = n23 + n25 * this.dimOffset[n2 - 1] * 16;
                            byArray[n22] = 3;
                            byArray[n22 + 1] = 0;
                            int n26 = nArray2[n25];
                            byArray[n22 + 8] = (byte)n26;
                            byArray[n22 + 9] = (byte)(n26 >>> 8 & 0xFF);
                            byArray[n22 + 10] = (byte)(n26 >>> 16 & 0xFF);
                            byArray[n22 + 11] = (byte)(n26 >>> 24 & 0xFF);
                            ++n25;
                        }
                        while (n25 < this.maxDimArray[n2 - 1]) {
                            n22 = n23 + n25 * this.dimOffset[n2 - 1] * 16;
                            byArray[n22 + 1] = 0;
                            byArray[n22] = 0;
                            ++n25;
                        }
                        break;
                    }
                    case 'J': {
                        int n27;
                        long[] lArray = (long[])object;
                        int n28 = n;
                        int n29 = 0;
                        while (n29 < n2 - 1) {
                            n28 += nArray[n29] * this.dimOffset[n29] * 16;
                            ++n29;
                        }
                        int n30 = 0;
                        while (n30 < lArray.length) {
                            n27 = n28 + n30 * this.dimOffset[n2 - 1] * 16;
                            byArray[n27] = 5;
                            byArray[n27 + 1] = 0;
                            long l = Double.doubleToLongBits(lArray[n30]);
                            byArray[n27 + 8] = (byte)l;
                            byArray[n27 + 9] = (byte)(l >>> 8 & 0xFFL);
                            byArray[n27 + 10] = (byte)(l >>> 16 & 0xFFL);
                            byArray[n27 + 11] = (byte)(l >>> 24 & 0xFFL);
                            byArray[n27 + 12] = (byte)(l >>> 32 & 0xFFL);
                            byArray[n27 + 13] = (byte)(l >>> 40 & 0xFFL);
                            byArray[n27 + 14] = (byte)(l >>> 48 & 0xFFL);
                            byArray[n27 + 15] = (byte)(l >>> 56 & 0xFFL);
                            ++n30;
                        }
                        while (n30 < this.maxDimArray[n2 - 1]) {
                            n27 = n28 + n30 * this.dimOffset[n2 - 1] * 16;
                            byArray[n27 + 1] = 0;
                            byArray[n27] = 0;
                            ++n30;
                        }
                        break;
                    }
                    case 'F': {
                        int n31;
                        float[] fArray = (float[])object;
                        int n32 = n;
                        int n33 = 0;
                        while (n33 < n2 - 1) {
                            n32 += nArray[n33] * this.dimOffset[n33] * 16;
                            ++n33;
                        }
                        int n34 = 0;
                        while (n34 < fArray.length) {
                            n31 = n32 + n34 * this.dimOffset[n2 - 1] * 16;
                            byArray[n31] = 4;
                            byArray[n31 + 1] = 0;
                            int n35 = Float.floatToIntBits(fArray[n34]);
                            byArray[n31 + 8] = (byte)n35;
                            byArray[n31 + 9] = (byte)(n35 >>> 8 & 0xFF);
                            byArray[n31 + 10] = (byte)(n35 >>> 16 & 0xFF);
                            byArray[n31 + 11] = (byte)(n35 >>> 24 & 0xFF);
                            ++n34;
                        }
                        while (n34 < this.maxDimArray[n2 - 1]) {
                            n31 = n32 + n34 * this.dimOffset[n2 - 1] * 16;
                            byArray[n31 + 1] = 0;
                            byArray[n31] = 0;
                            ++n34;
                        }
                        break;
                    }
                    case 'D': {
                        int n36;
                        double[] dArray = (double[])object;
                        int n37 = n;
                        int n38 = 0;
                        while (n38 < n2 - 1) {
                            n37 += nArray[n38] * this.dimOffset[n38] * 16;
                            ++n38;
                        }
                        int n39 = 0;
                        while (n39 < dArray.length) {
                            n36 = n37 + n39 * this.dimOffset[n2 - 1] * 16;
                            byArray[n36] = 5;
                            byArray[n36 + 1] = 0;
                            long l = Double.doubleToLongBits(dArray[n39]);
                            byArray[n36 + 8] = (byte)l;
                            byArray[n36 + 9] = (byte)(l >>> 8 & 0xFFL);
                            byArray[n36 + 10] = (byte)(l >>> 16 & 0xFFL);
                            byArray[n36 + 11] = (byte)(l >>> 24 & 0xFFL);
                            byArray[n36 + 12] = (byte)(l >>> 32 & 0xFFL);
                            byArray[n36 + 13] = (byte)(l >>> 40 & 0xFFL);
                            byArray[n36 + 14] = (byte)(l >>> 48 & 0xFFL);
                            byArray[n36 + 15] = (byte)(l >>> 56 & 0xFFL);
                            ++n39;
                        }
                        while (n39 < this.maxDimArray[n2 - 1]) {
                            n36 = n37 + n39 * this.dimOffset[n2 - 1] * 16;
                            byArray[n36 + 1] = 0;
                            byArray[n36] = 0;
                            ++n39;
                        }
                        break;
                    }
                    default: {
                        int n40;
                        Object[] objectArray = (Object[])object;
                        int n41 = n;
                        int n42 = 0;
                        while (n42 < n2 - 1) {
                            n41 += nArray[n42] * this.dimOffset[n42] * 16;
                            ++n42;
                        }
                        int n43 = 0;
                        while (n43 < objectArray.length) {
                            n40 = n41 + n43 * this.dimOffset[n2 - 1] * 16;
                            if (objectArray[n43] == null) {
                                byArray[n40] = 1;
                                byArray[n40 + 1] = 0;
                            } else if (objectArray[n43] instanceof Boolean) {
                                int n44;
                                byArray[n40] = 11;
                                byArray[n40 + 1] = 0;
                                byArray[n40 + 8] = n44 = (Boolean)objectArray[n43] != false ? -1 : 0;
                                byArray[n40 + 9] = n44;
                                byArray[n40 + 10] = n44;
                                byArray[n40 + 11] = n44;
                            } else if (objectArray[n43] instanceof Integer) {
                                byArray[n40] = 3;
                                byArray[n40 + 1] = 0;
                                int n45 = (Integer)objectArray[n43];
                                byArray[n40 + 8] = (byte)n45;
                                byArray[n40 + 9] = (byte)(n45 >>> 8 & 0xFF);
                                byArray[n40 + 10] = (byte)(n45 >>> 16 & 0xFF);
                                byArray[n40 + 11] = (byte)(n45 >>> 24 & 0xFF);
                            } else if (objectArray[n43] instanceof String) {
                                byte[] byArray3 = ActiveScriptEngine.this.nativeStingToBString((String)objectArray[n43]);
                                byArray[n40] = 8;
                                byArray[n40 + 1] = 0;
                                byArray[n40 + 8] = byArray3[0];
                                byArray[n40 + 9] = byArray3[1];
                                byArray[n40 + 10] = byArray3[2];
                                byArray[n40 + 11] = byArray3[3];
                            } else if (objectArray[n43] instanceof Long) {
                                byArray[n40] = 5;
                                byArray[n40 + 1] = 0;
                                long l = Double.doubleToLongBits(((Long)objectArray[n43]).longValue());
                                byArray[n40 + 8] = (byte)l;
                                byArray[n40 + 9] = (byte)(l >>> 8 & 0xFFL);
                                byArray[n40 + 10] = (byte)(l >>> 16 & 0xFFL);
                                byArray[n40 + 11] = (byte)(l >>> 24 & 0xFFL);
                                byArray[n40 + 12] = (byte)(l >>> 32 & 0xFFL);
                                byArray[n40 + 13] = (byte)(l >>> 40 & 0xFFL);
                                byArray[n40 + 14] = (byte)(l >>> 48 & 0xFFL);
                                byArray[n40 + 15] = (byte)(l >>> 56 & 0xFFL);
                            } else if (objectArray[n43] instanceof Short) {
                                byArray[n40] = 2;
                                byArray[n40 + 1] = 0;
                                int n46 = ((Short)objectArray[n43]).intValue();
                                byArray[n40 + 8] = (byte)n46;
                                byArray[n40 + 9] = (byte)(n46 >>> 8 & 0xFF);
                                byArray[n40 + 10] = (byte)(n46 >>> 16 & 0xFF);
                                byArray[n40 + 11] = (byte)(n46 >>> 24 & 0xFF);
                            } else if (objectArray[n43] instanceof Float) {
                                byArray[n40] = 4;
                                byArray[n40 + 1] = 0;
                                int n47 = Float.floatToIntBits(((Float)objectArray[n43]).floatValue());
                                byArray[n40 + 8] = (byte)n47;
                                byArray[n40 + 9] = (byte)(n47 >>> 8 & 0xFF);
                                byArray[n40 + 10] = (byte)(n47 >>> 16 & 0xFF);
                                byArray[n40 + 11] = (byte)(n47 >>> 24 & 0xFF);
                            } else if (objectArray[n43] instanceof Double) {
                                byArray[n40] = 5;
                                byArray[n40 + 1] = 0;
                                long l = Double.doubleToLongBits((Double)objectArray[n43]);
                                byArray[n40 + 8] = (byte)l;
                                byArray[n40 + 9] = (byte)(l >>> 8 & 0xFFL);
                                byArray[n40 + 10] = (byte)(l >>> 16 & 0xFFL);
                                byArray[n40 + 11] = (byte)(l >>> 24 & 0xFFL);
                                byArray[n40 + 12] = (byte)(l >>> 32 & 0xFFL);
                                byArray[n40 + 13] = (byte)(l >>> 40 & 0xFFL);
                                byArray[n40 + 14] = (byte)(l >>> 48 & 0xFFL);
                                byArray[n40 + 15] = (byte)(l >>> 56 & 0xFFL);
                            } else if (objectArray[n43] instanceof Byte) {
                                byte by;
                                byArray[n40] = 17;
                                byArray[n40 + 1] = 0;
                                byArray[n40 + 8] = by = ((Byte)objectArray[n43]).byteValue();
                            } else if (objectArray[n43] instanceof Character) {
                                byte by;
                                byArray[n40] = 17;
                                byArray[n40 + 1] = 0;
                                byArray[n40 + 8] = by = (byte)((Character)objectArray[n43]).charValue();
                            } else if (objectArray[n43] instanceof Void) {
                                byArray[n40] = 1;
                                byArray[n40 + 1] = 0;
                            } else {
                                byte[] byArray4 = null;
                                byArray[n40] = 9;
                                byArray[n40 + 1] = 0;
                                byArray4 = object instanceof COMIDispatchBean ? ((COMIDispatchBean)objectArray[n43]).getIDispatchInterface() : ActiveScriptEngine.this.nativeObjectToVariant(ActiveScriptEngine.this.css, objectArray[n43]);
                                System.arraycopy(byArray4, 0, byArray, n40 + 8, byArray4.length);
                            }
                            ++n43;
                        }
                        while (n43 < this.maxDimArray[n2 - 1]) {
                            n40 = n41 + n43 * this.dimOffset[n2 - 1] * 16;
                            byArray[n40 + 1] = 0;
                            byArray[n40] = 0;
                            ++n43;
                        }
                        break;
                    }
                }
            }
            return n;
        }

        byte[] toVariant() throws BSFException {
            this.investigate(this.arrayObject, 0);
            int n = this.maxDimArray[0];
            int n2 = 1;
            while (n2 < this.maxDepth) {
                n *= this.maxDimArray[n2];
                ++n2;
            }
            int n3 = 32 + 8 * this.maxDepth + n * 16;
            byte[] byArray = new byte[n3];
            byArray[0] = 12;
            byArray[1] = 32;
            byArray[16] = (byte)this.maxDepth;
            byArray[17] = (byte)(this.maxDepth >>> 8 & 0xFF);
            byArray[18] = -110;
            byArray[19] = 8;
            byArray[20] = 16;
            byArray[23] = 0;
            byArray[22] = 0;
            byArray[21] = 0;
            byArray[27] = 0;
            byArray[26] = 0;
            byArray[25] = 0;
            byArray[24] = 0;
            int n4 = 0;
            int n5 = 32;
            n4 = this.maxDepth - 1;
            while (n4 >= 0) {
                byArray[n5++] = (byte)this.maxDimArray[n4];
                byArray[n5++] = (byte)(this.maxDimArray[n4] >>> 8 & 0xFF);
                byArray[n5++] = (byte)(this.maxDimArray[n4] >>> 16 & 0xFF);
                byArray[n5++] = (byte)(this.maxDimArray[n4] >>> 24 & 0xFF);
                byArray[n5++] = 0;
                byArray[n5++] = 0;
                byArray[n5++] = 0;
                byArray[n5++] = 0;
                --n4;
            }
            byArray[31] = 0;
            byArray[30] = 0;
            byArray[29] = 0;
            byArray[28] = 0;
            byArray[28] = (byte)n5;
            byArray[29] = (byte)(n5 >>> 8 & 0xFF);
            byArray[30] = (byte)(n5 >>> 16 & 0xFF);
            byArray[31] = (byte)(n5 >>> 24 & 0xFF);
            this.setVariantData(this.arrayObject, byArray, n5, 0, new int[this.maxDepth]);
            return byArray;
        }

        ArrayInfo(Object object) {
            if (object.getClass().isArray()) {
                String string = object.getClass().toString();
                this.maxDepth = string.indexOf(91);
                if (-1 != this.maxDepth) {
                    this.arrayObject = object;
                    string = string.substring(this.maxDepth);
                    this.maxDepth = 0;
                    while (string.charAt(this.maxDepth) == '[') {
                        ++this.maxDepth;
                    }
                    this.type = string.charAt(this.maxDepth);
                    this.maxDimArray = new int[this.maxDepth];
                    this.dimOffset = new int[this.maxDepth];
                    this.investigate(object, 0);
                    this.dimOffset[0] = 1;
                    int n = 1;
                    while (n < this.maxDepth) {
                        this.dimOffset[n] = this.dimOffset[n - 1] * this.maxDimArray[n - 1];
                        ++n;
                    }
                }
            }
        }
    }
}

