/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.compilers;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jci.compilers.JavaCompiler;
import org.apache.commons.jci.utils.ConversionUtils;

public final class JavaCompilerFactory {
    private static final JavaCompilerFactory INSTANCE = new JavaCompilerFactory();
    private final Map classCache = new HashMap();

    public static JavaCompilerFactory getInstance() {
        return INSTANCE;
    }

    public JavaCompiler createCompiler(String pHint) {
        String className = pHint.indexOf(46) < 0 ? "org.apache.commons.jci.compilers." + ConversionUtils.toJavaCasing(pHint) + "JavaCompiler" : pHint;
        Class<?> clazz = (Class<?>)this.classCache.get(className);
        if (clazz == null) {
            try {
                clazz = Class.forName(className);
                this.classCache.put(className, clazz);
            }
            catch (ClassNotFoundException e) {
                clazz = null;
            }
        }
        if (clazz == null) {
            return null;
        }
        try {
            return (JavaCompiler)clazz.newInstance();
        }
        catch (Throwable t) {
            return null;
        }
    }
}

