/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StatusGetter {
    private static final URL DEFAULT_INVOKE_URL;
    private boolean m_verbose = false;
    private URL m_invokeURL = DEFAULT_INVOKE_URL;
    private Status m_status = Status.UNKNOWN;

    public boolean isVerbose() {
        return this.m_verbose;
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public URL getInvokeURL() {
        return this.m_invokeURL;
    }

    public void setInvokeURL(URL invokeURL) {
        this.m_invokeURL = invokeURL;
    }

    public Status getStatus() {
        return this.m_status;
    }

    public static void main(String[] argv) throws Exception {
        StatusGetter statusGetter = new StatusGetter();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-h")) {
                System.out.println("Accepted options:");
                System.out.println("        -v              Verbose mode.");
                System.out.println("        -u <URL>        Alternate invoker URL.");
                System.out.println("The default invoker URL is: " + statusGetter.getInvokeURL());
                statusGetter.setVerbose(true);
                continue;
            }
            if (argv[i].equals("-v")) {
                statusGetter.setVerbose(true);
                continue;
            }
            if (argv[i].equals("-u")) {
                statusGetter.setInvokeURL(new URL(argv[i + 1]));
                ++i;
                continue;
            }
            throw new Exception("Invalid command-line option: \"" + argv[i] + "\"");
        }
        Authenticator.setDefault(new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication("manager", "manager".toCharArray());
            }
        });
        statusGetter.queryStatus();
        if (statusGetter.getStatus() == Status.NOT_RUNNING || statusGetter.getStatus() == Status.CONNECTION_REFUSED) {
            System.exit(3);
        } else if (statusGetter.getStatus() == Status.PARTIALLY_RUNNING) {
            System.exit(160);
        } else if (statusGetter.getStatus() == Status.RUNNING) {
            System.exit(0);
        } else {
            throw new Exception("Unknown status returned from statusGetter.getStatus(): " + (Object)((Object)statusGetter.getStatus()));
        }
    }

    public void queryStatus() throws Exception {
        String line;
        BufferedReader reader;
        URLConnection connection = this.m_invokeURL.openConnection();
        try {
            connection.connect();
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        }
        catch (ConnectException e) {
            if (this.isVerbose()) {
                System.out.println("Could not connect to " + this.getInvokeURL().getHost() + " on port " + this.getInvokeURL().getPort() + " (OpenNMS might not be running or " + "could be starting up or shutting down): " + e.getMessage());
            }
            this.m_status = Status.CONNECTION_REFUSED;
            return;
        }
        StringBuffer statusResultsBuf = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            statusResultsBuf.append(line);
            statusResultsBuf.append("\n");
        }
        String statusResults = statusResultsBuf.toString();
        int i = statusResults.indexOf("return=\"[");
        if (i == -1) {
            throw new Exception("could not find start of status results");
        }
        if ((i = (statusResults = statusResults.substring(i + "return=\"[".length())).indexOf("]\"")) == -1) {
            throw new Exception("could not find end of status results");
        }
        statusResults = statusResults.substring(0, i);
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        Pattern p = Pattern.compile("Status: OpenNMS:Name=(\\S+) = (\\S+)");
        while (statusResults.length() > 0) {
            i = statusResults.indexOf(", ");
            String result = i == -1 ? statusResults : statusResults.substring(0, i);
            Matcher m = p.matcher(result);
            if (!m.matches()) {
                throw new Exception("Result \"" + result + "\" does not match our regular expression");
            }
            results.put(m.group(1), m.group(2));
            if (i == -1) break;
            statusResults = statusResults.substring(i + ", ".length());
        }
        String spaces = "               ";
        int running = 0;
        int services = 0;
        for (Map.Entry entry : results.entrySet()) {
            String daemon = (String)entry.getKey();
            String status = ((String)entry.getValue()).toLowerCase();
            ++services;
            if (status.equals("running")) {
                ++running;
            }
            if (!this.m_verbose) continue;
            System.out.println("OpenNMS." + daemon + spaces.substring(daemon.length()) + ": " + status);
        }
        this.m_status = services == 0 ? Status.NOT_RUNNING : (running != services ? Status.PARTIALLY_RUNNING : Status.RUNNING);
    }

    static {
        try {
            DEFAULT_INVOKE_URL = new URL("http://127.0.0.1:8181/invoke?objectname=OpenNMS:Name=Manager&operation=status");
        }
        catch (MalformedURLException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNKNOWN,
        RUNNING,
        PARTIALLY_RUNNING,
        NOT_RUNNING,
        CONNECTION_REFUSED;

    }
}

