/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Category;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.core.utils.ThreadCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfLabel {
    protected static Category log = ThreadCategory.getInstance(IfLabel.class);

    public static Map<String, String> getInterfaceInfoFromIfLabel(Connection conn, int nodeId, String ifLabel) throws SQLException {
        if (ifLabel == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        HashMap<String, String> info = new HashMap<String, String>();
        String desc = ifLabel;
        String mac = null;
        int dashIndex = ifLabel.lastIndexOf("-");
        if (dashIndex >= 0) {
            desc = ifLabel.substring(0, dashIndex);
            mac = ifLabel.substring(dashIndex + 1, ifLabel.length());
        }
        log.debug((Object)("getInterfaceInfoFromIfLabel: desc=" + desc + " mac=" + mac));
        String query = "SELECT * FROM snmpinterface WHERE nodeid = '" + String.valueOf(nodeId) + "'";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            if (rs.getString("snmpifdescr") != null && Pattern.matches(".*-cef.*", rs.getString("snmpifdescr")) || !AlphaNumeric.parseAndReplace((String)rs.getString("snmpifname"), (char)'_').equals(desc) && !AlphaNumeric.parseAndReplace((String)rs.getString("snmpifdescr"), (char)'_').equals(desc) || mac != null && !mac.equals(rs.getString("snmpphysaddr"))) continue;
            ThreadCategory.getInstance(IfLabel.class).debug((Object)"getInterfaceInfoFromIfLabel: found match...");
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                info.put(rs.getMetaData().getColumnName(i), rs.getString(i));
            }
        }
        rs.close();
        stmt.close();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getInterfaceInfoFromIfLabel(int nodeId, String ifLabel) throws SQLException {
        Connection conn = Vault.getDbConnection();
        Map<String, String> info = null;
        try {
            info = IfLabel.getInterfaceInfoFromIfLabel(conn, nodeId, ifLabel);
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getIfLabels(int nodeId) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        Connection conn = Vault.getDbConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT snmpifname, snmpifdescr,snmpphysaddr from snmpinterface, ipinterface where (ipinterface.ismanaged!='D') AND ipinterface.nodeid=snmpinterface.nodeid AND ifindex = snmpifindex AND ipinterface.nodeid=?");
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString("snmpifname");
                String descr = rs.getString("snmpifdescr");
                String physAddr = rs.getString("snmpphysaddr");
                list.add(IfLabel.getIfLabel(name, descr, physAddr));
            }
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        String[] labels = list.toArray(new String[list.size()]);
        return labels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIfLabel(int nodeId, String ipAddr) throws SQLException {
        if (ipAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String label = null;
        Connection conn = Vault.getDbConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT snmpifname, snmpifdescr,snmpphysaddr from snmpinterface, ipinterface where (ipinterface.ismanaged!='D') AND ipinterface.nodeid=snmpinterface.nodeid AND ifindex=snmpifindex AND ipinterface.nodeid=? AND ipinterface.ipaddr=?");
            stmt.setInt(1, nodeId);
            stmt.setString(2, ipAddr);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                String name = rs.getString("snmpifname");
                String descr = rs.getString("snmpifdescr");
                String physAddr = rs.getString("snmpphysaddr");
                if (name != null || descr != null) {
                    label = IfLabel.getIfLabel(name, descr, physAddr);
                } else {
                    log.warn((Object)("Interface (nodeId/ipAddr=" + nodeId + "/" + ipAddr + ") has no ifName and no ifDescr...setting to label to 'no_ifLabel'."));
                    label = "no_ifLabel";
                }
            }
            if (rs.next()) {
                log.warn((Object)("Found more than one interface for node=" + nodeId + " ip=" + ipAddr));
            }
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIfLabelfromIfIndex(int nodeId, String ipAddr, String ifIndex) throws SQLException {
        if (ipAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String label = null;
        Connection conn = Vault.getDbConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT snmpifname, snmpifdescr,snmpphysaddr from snmpinterface, ipinterface where (ipinterface.ismanaged!='D') AND ipinterface.nodeid=snmpinterface.nodeid AND ifindex=snmpifindex AND ipinterface.nodeid=? AND ipinterface.ipaddr=? AND ipinterface.ifindex=?");
            stmt.setInt(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.setString(3, ifIndex);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                String name = rs.getString("snmpifname");
                String descr = rs.getString("snmpifdescr");
                String physAddr = rs.getString("snmpphysaddr");
                if (name != null || descr != null) {
                    label = IfLabel.getIfLabel(name, descr, physAddr);
                } else {
                    log.warn((Object)("Interface (nodeId/ipAddr=" + nodeId + "/" + ipAddr + ") has no ifName and no ifDescr...setting to label to 'no_ifLabel'."));
                    label = "no_ifLabel";
                }
            }
            if (rs.next()) {
                log.warn((Object)("Found more than one interface for node=" + nodeId + " ip=" + ipAddr));
            }
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return label;
    }

    public static String getIfLabel(String name, String descr, String physAddr) {
        String label = null;
        if (name != null) {
            label = AlphaNumeric.parseAndReplace((String)name, (char)'_');
        } else if (descr != null) {
            label = AlphaNumeric.parseAndReplace((String)descr, (char)'_');
        } else {
            throw new IllegalArgumentException("Both name and descr are null, but at least one cannot be.");
        }
        if (physAddr != null) {
            if ((physAddr = AlphaNumeric.parseAndTrim((String)physAddr)).length() == 12) {
                label = label + "-" + physAddr;
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("initialize: physical address len is NOT 12, physAddr=" + physAddr));
            }
        }
        return label;
    }
}

