/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.protocols.InsufficientParametersException;

public class Ssh {
    public static final int DEFAULT_TIMEOUT = 30000;
    public static final int DEFAULT_PORT = 22;
    JSch m_jsch = new JSch();
    private Session m_session;
    private Throwable m_exception;
    private String m_serverVersion;
    private InetAddress m_address;
    private int m_port = 22;
    private int m_timeout = 30000;
    private File m_keydir;
    private String m_username;
    private String m_password;

    public void setAddress(InetAddress address) {
        this.m_address = address;
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setTimeout(int milliseconds) {
        this.m_timeout = milliseconds;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setKeyDirectory(File directory) {
        this.m_keydir = directory;
    }

    public File getKeyDirectory() {
        return this.m_keydir;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getServerVersion() {
        return this.m_serverVersion;
    }

    protected Session getSession() {
        return this.m_session;
    }

    protected boolean connect() throws InsufficientParametersException {
        if (this.getAddress() == null) {
            throw new InsufficientParametersException("you must specify an address");
        }
        this.m_exception = null;
        this.m_serverVersion = null;
        this.m_session = null;
        try {
            this.m_session = this.m_jsch.getSession("opennms", this.getAddress().getHostAddress(), this.getPort());
            this.m_session.connect(this.getTimeout());
            this.m_serverVersion = this.m_session.getServerVersion();
            return true;
        }
        catch (JSchException e) {
            this.m_exception = e;
            if (e.getCause() != null) {
                Class<?> cause = e.getCause().getClass();
                if (cause == ConnectException.class) {
                    this.log().debug((Object)"connection refused", (Throwable)e);
                    return false;
                }
                if (cause == NoRouteToHostException.class) {
                    this.log().debug((Object)"no route to host", (Throwable)e);
                    return false;
                }
                if (cause == InterruptedIOException.class) {
                    this.log().debug((Object)"connection timeout", (Throwable)e);
                    return false;
                }
                if (cause == IOException.class) {
                    this.log().debug((Object)"An I/O exception occurred", (Throwable)e);
                    return false;
                }
                if (e.getMessage().matches("^.*(connection is closed by foreign host).*$")) {
                    this.log().debug((Object)"JSCH failed", (Throwable)e);
                    return false;
                }
            } else if (e.getMessage().matches("^.*(socket is not established|connection is closed by foreign host|java.io.(IOException|InterruptedIOException)|java.net.(ConnectException|NoRouteToHostException)).*$")) {
                this.log().debug((Object)"did not connect enough to verify SSH server", (Throwable)e);
                return false;
            }
            if (this.m_session != null && this.m_session.isConnected()) {
                this.m_serverVersion = this.m_session.getServerVersion();
            }
            this.log().debug((Object)("valid SSH server is listening: " + e.getMessage()));
            return true;
        }
    }

    protected Throwable getError() {
        return this.m_exception;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

