/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.poller.IPv4NetworkInterface;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.remote.OnmsPollModel;

public class PolledService
implements MonitoredService,
Serializable {
    private static final long serialVersionUID = 1L;
    private IPv4NetworkInterface m_netInterface;
    private Map m_monitorConfiguration;
    private OnmsPollModel m_pollModel;
    private Integer m_serviceId;
    private Integer m_nodeId;
    private String m_nodeLabel;
    private String m_svcName;

    public PolledService(OnmsMonitoredService monitoredService, Map monitorConfiguration, OnmsPollModel pollModel) {
        this.m_serviceId = monitoredService.getId();
        this.m_nodeId = monitoredService.getNodeId();
        this.m_nodeLabel = monitoredService.getIpInterface().getNode().getLabel();
        this.m_svcName = monitoredService.getServiceName();
        this.m_netInterface = new IPv4NetworkInterface(monitoredService.getIpInterface().getInetAddress());
        this.m_monitorConfiguration = monitorConfiguration;
        this.m_pollModel = pollModel;
    }

    public Integer getServiceId() {
        return this.m_serviceId;
    }

    public InetAddress getAddress() {
        return this.m_netInterface.getInetAddress();
    }

    public String getIpAddr() {
        return this.m_netInterface.getInetAddress().getHostAddress();
    }

    public NetworkInterface getNetInterface() {
        return this.m_netInterface;
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public String getNodeLabel() {
        return this.m_nodeLabel;
    }

    public String getSvcName() {
        return this.m_svcName;
    }

    public Map getMonitorConfiguration() {
        return this.m_monitorConfiguration;
    }

    public OnmsPollModel getPollModel() {
        return this.m_pollModel;
    }

    public String toString() {
        return this.getNodeId() + ":" + this.getIpAddr() + ":" + this.getSvcName();
    }
}

