/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.poller.monitors.TimeoutTracker;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable
public final class TcpMonitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = -1;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, "port", -1);
        if (port == -1) {
            throw new RuntimeException("TcpMonitor: required parameter 'port' is not present in supplied properties.");
        }
        String strBannerMatch = (String)parameters.get("banner");
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("poll: address = " + ipv4Addr.getHostAddress() + ", port = " + port + ", " + tracker));
        }
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            Socket socket = null;
            try {
                tracker.startAttempt();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                socket.setSoTimeout(tracker.getSoTimeout());
                this.log().debug((Object)("TcpMonitor: connected to host: " + ipv4Addr + " on port: " + port));
                serviceStatus = PollStatus.unresponsive();
                if (strBannerMatch == null || strBannerMatch.length() == 0 || strBannerMatch.equals("*")) {
                    serviceStatus = PollStatus.available((Double)tracker.elapsedTimeInMillis());
                    break;
                }
                BufferedReader rdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String response = rdr.readLine();
                double responseTime = tracker.elapsedTimeInMillis();
                if (response != null) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("poll: banner = " + response));
                        this.log().debug((Object)("poll: responseTime= " + responseTime + "ms"));
                    }
                    serviceStatus = response.indexOf(strBannerMatch) > -1 ? PollStatus.available((Double)responseTime) : PollStatus.unavailable((String)("Banner: '" + response + "' does not contain match string '" + strBannerMatch + "'"));
                }
            }
            catch (NoRouteToHostException e) {
                serviceStatus = this.logDown(Level.WARN, "No route to host exception for address " + ipv4Addr.getHostAddress(), e);
                break;
            }
            catch (InterruptedIOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "did not connect to host with " + tracker);
            }
            catch (ConnectException e) {
                serviceStatus = this.logDown(Level.DEBUG, "Connection exception for address: " + ipv4Addr, e);
            }
            catch (IOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "IOException while polling address: " + ipv4Addr, e);
            }
            finally {
                block38: {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (!this.log().isDebugEnabled()) break block38;
                        this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                    }
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }
}

