/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.poller.monitors.TimeoutTracker;
import org.opennms.netmgt.poller.nsclient.NsclientCheckParams;
import org.opennms.netmgt.poller.nsclient.NsclientException;
import org.opennms.netmgt.poller.nsclient.NsclientManager;
import org.opennms.netmgt.poller.nsclient.NsclientPacket;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable
public class NsclientMonitor
extends IPv4Monitor {
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    public PollStatus poll(MonitoredService svc, Map parameters) {
        String reason = null;
        int serviceStatus = 3;
        NsclientPacket response = null;
        Double responseTime = null;
        NetworkInterface iface = svc.getNetInterface();
        Category log = ThreadCategory.getInstance(this.getClass());
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        String command = ParameterMap.getKeyedString(parameters, "command", NsclientManager.convertTypeToString("1"));
        int port = ParameterMap.getKeyedInteger(parameters, "port", NsclientManager.DEFAULT_PORT);
        String password = ParameterMap.getKeyedString(parameters, "password", "None");
        String params = ParameterMap.getKeyedString(parameters, "parameter", null);
        int critPerc = ParameterMap.getKeyedInteger(parameters, "criticalPercent", 0);
        int warnPerc = ParameterMap.getKeyedInteger(parameters, "warningPercent", 0);
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        tracker.reset();
        while (tracker.shouldRetry() && serviceStatus != 1) {
            try {
                tracker.startAttempt();
                NsclientManager client = new NsclientManager(ipv4Addr.getHostAddress(), port, password);
                client.setTimeout(tracker.getSoTimeout());
                client.setPassword(password);
                client.init();
                NsclientCheckParams clientParams = new NsclientCheckParams(critPerc, warnPerc, params);
                response = client.processCheckCommand(NsclientManager.convertStringToType(command), clientParams);
                responseTime = tracker.elapsedTimeInMillis();
                if (response != null) {
                    if (response.getResultCode() == 0) {
                        serviceStatus = 1;
                        reason = response.getResponse();
                    } else if (response.getResultCode() == 2) {
                        serviceStatus = 2;
                        reason = response.getResponse();
                        responseTime = null;
                    }
                }
            }
            catch (NsclientException e) {
                log.debug((Object)("Nsclient Poller received exception from client: " + e.getMessage()));
                reason = "NsclientException: " + e.getMessage();
            }
            tracker.nextAttempt();
        }
        return PollStatus.get((int)serviceStatus, reason, responseTime);
    }
}

