/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.poller.monitors.TimeoutTracker;
import org.opennms.netmgt.poller.nrpe.NrpeException;
import org.opennms.netmgt.poller.nrpe.NrpePacket;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable
public final class NrpeMonitor
extends IPv4Monitor {
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        String reason = null;
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        String command = ParameterMap.getKeyedString(parameters, "command", "_NRPE_CHECK");
        int port = ParameterMap.getKeyedInteger(parameters, "port", 5666);
        int padding = ParameterMap.getKeyedInteger(parameters, "padding", 2);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("poll: address = " + ipv4Addr.getHostAddress() + ", port = " + port + ", " + tracker));
        }
        int serviceStatus = 2;
        Double responseTime = null;
        tracker.reset();
        while (tracker.shouldRetry() && serviceStatus != 1) {
            Socket socket = null;
            try {
                tracker.startAttempt();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                socket.setSoTimeout(tracker.getSoTimeout());
                this.log().debug((Object)("NrpeMonitor: connected to host: " + ipv4Addr + " on port: " + port));
                serviceStatus = 3;
                reason = "Connected, but no response received";
                NrpePacket p = new NrpePacket(1, 0, command);
                byte[] b = p.buildPacket(padding);
                OutputStream o = socket.getOutputStream();
                o.write(b);
                NrpePacket response = NrpePacket.receivePacket(socket.getInputStream(), padding);
                responseTime = tracker.elapsedTimeInMillis();
                if (response.getResultCode() == 0) {
                    serviceStatus = 1;
                    reason = null;
                } else {
                    serviceStatus = 2;
                    reason = "NRPE command returned code " + response.getResultCode() + " and message: " + response.getBuffer();
                }
            }
            catch (NoRouteToHostException e) {
                reason = "No route to host exception for address " + ipv4Addr.getHostAddress();
                if (this.log().isEnabledFor((Priority)Level.WARN)) {
                    e.fillInStackTrace();
                    this.log().warn((Object)("poll: " + reason), (Throwable)e);
                }
            }
            catch (InterruptedIOException e) {
                reason = "did not connect to host within " + tracker;
                this.log().debug((Object)("NrpeMonitor: did not connect to host within " + tracker));
            }
            catch (ConnectException e) {
                reason = "Connection exception for address: " + ipv4Addr;
                if (this.log().isDebugEnabled()) {
                    e.fillInStackTrace();
                    this.log().debug((Object)("poll: " + reason), (Throwable)e);
                }
            }
            catch (NrpeException e) {
                reason = "NrpeException while polling address: " + ipv4Addr;
                if (this.log().isDebugEnabled()) {
                    e.fillInStackTrace();
                    this.log().debug((Object)("poll: " + reason), (Throwable)e);
                }
            }
            catch (IOException e) {
                reason = "IOException while polling address: " + ipv4Addr;
                if (this.log().isDebugEnabled()) {
                    e.fillInStackTrace();
                    this.log().debug((Object)("poll: " + reason), (Throwable)e);
                }
            }
            finally {
                block39: {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        if (!this.log().isDebugEnabled()) break block39;
                        e.fillInStackTrace();
                        this.log().debug((Object)"poll: Error closing socket.", (Throwable)e);
                    }
                }
            }
            tracker.nextAttempt();
        }
        if (reason == null) {
            return PollStatus.get((int)serviceStatus, responseTime);
        }
        return PollStatus.get((int)serviceStatus, reason);
    }
}

