/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Map;
import org.apache.regexp.RE;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.poller.monitors.TimeoutTracker;
import org.opennms.netmgt.protocols.InsufficientParametersException;
import org.opennms.netmgt.protocols.ssh.Poll;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable
public final class JschSshMonitor
extends IPv4Monitor {
    private static final int DEFAULT_RETRY = 0;
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_PORT = 22;

    public PollStatus poll(InetAddress address, Map parameters) {
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, "port", 22);
        String banner = ParameterMap.getKeyedString(parameters, "banner", null);
        String match = ParameterMap.getKeyedString(parameters, "match", null);
        PollStatus ps = PollStatus.unavailable();
        Poll ssh = new Poll(address, port, tracker.getConnectionTimeout());
        RE regex = null;
        if (match == null && (banner == null || banner.equals("*"))) {
            regex = null;
        } else if (match != null) {
            regex = new RE(match);
        } else if (banner != null) {
            regex = new RE(banner);
        }
        tracker.reset();
        while (tracker.shouldRetry() && !ps.isAvailable()) {
            try {
                ps = ssh.poll(tracker);
            }
            catch (InsufficientParametersException e) {
                this.log().error((Object)e);
                break;
            }
            if (ps.isAvailable()) {
                if (regex == null) {
                    return ps;
                }
                String response = ssh.getServerVersion();
                if (regex.match(response)) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("isServer: matching response=" + response));
                    }
                    return ps;
                }
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("isServer: NON-matching response=" + response));
                }
                return PollStatus.unavailable((String)("server responded, but banner did not match '" + banner + "'"));
            }
            tracker.nextAttempt();
        }
        return ps;
    }

    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        InetAddress address = (InetAddress)iface.getAddress();
        return this.poll(address, parameters);
    }
}

