/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.ping.Pinger;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable(value={DistributionContext.DAEMON})
public final class IcmpMonitor
extends IPv4Monitor {
    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        PollStatus serviceStatus = PollStatus.unavailable();
        Double rtt = null;
        InetAddress host = (InetAddress)iface.getAddress();
        try {
            int retries = ParameterMap.getKeyedInteger(parameters, "retry", 2);
            long timeout = ParameterMap.getKeyedLong(parameters, "timeout", 800L);
            rtt = (double)Pinger.ping((InetAddress)host, (long)timeout, (int)retries);
        }
        catch (Exception e) {
            log.debug((Object)("failed to ping " + host), (Throwable)e);
        }
        if (rtt != null) {
            return PollStatus.available(rtt);
        }
        return PollStatus.unavailable();
    }
}

