/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.poller.monitors.TimeoutTracker;

@Distributable
public class AvailabilityMonitor
extends IPv4Monitor {
    private static final int DEFAULT_RETRY = 3;
    private static final int DEFAULT_TIMEOUT = 3000;

    public void initialize(Map parameters) {
    }

    public void initialize(MonitoredService svc) {
    }

    public PollStatus poll(MonitoredService svc, Map parameters) {
        TimeoutTracker timeoutTracker = new TimeoutTracker(parameters, 3, 3000);
        timeoutTracker.reset();
        while (timeoutTracker.shouldRetry()) {
            try {
                timeoutTracker.startAttempt();
                if (svc.getAddress().isReachable(timeoutTracker.getSoTimeout())) {
                    return PollStatus.available((Double)timeoutTracker.elapsedTimeInMillis());
                }
            }
            catch (IOException e) {
                this.logDown(Level.INFO, "Unable to contact " + svc.getIpAddr(), e);
            }
            timeoutTracker.nextAttempt();
        }
        return this.logDown(Level.INFO, svc + " failed to respond");
    }

    public void release() {
    }

    public void release(MonitoredService svc) {
    }
}

