/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.Argument;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.notifd.ExecutorStrategy;
import org.opennms.netmgt.notifd.NotificationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassExecutor
implements ExecutorStrategy {
    @Override
    public int execute(String className, List<Argument> arguments) {
        NotificationStrategy ns;
        this.log().debug((Object)("Going for the class instance: " + className));
        try {
            ns = (NotificationStrategy)Class.forName(className).newInstance();
            this.log().debug((Object)(className + " class created: " + ns.getClass()));
        }
        catch (Exception e) {
            this.log().error((Object)("Execption creating notification strategy class: " + className), (Throwable)e);
            return 1;
        }
        try {
            return ns.send(arguments);
        }
        catch (Throwable t) {
            this.log().error((Object)("Throwable received while sending message: " + t), t);
            return 1;
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

