/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

public final class FdbTableGet {
    private static final String FDB_PORT_OID = ".1.3.6.1.2.1.17.4.3.1.2";
    private static final String FDB_STATUS_OID = ".1.3.6.1.2.1.17.4.3.1.3";
    private static final String QFDB_PORT_OID = ".1.3.6.1.2.1.17.7.1.2.2.1.2";
    private static final String QFDB_STATUS_OID = ".1.3.6.1.2.1.17.7.1.2.2.1.3";
    private SnmpAgentConfig m_agentConfig;
    private String m_mac;

    public FdbTableGet(SnmpAgentConfig config, String mac) {
        this.m_agentConfig = config;
        this.m_mac = this.getInstanceString(mac);
    }

    public int getBridgePort() {
        Category log = ThreadCategory.getInstance(this.getClass());
        SnmpValue val = SnmpUtils.get((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId)this.getOid(FDB_PORT_OID));
        if (val == null) {
            return -1;
        }
        if (val.isNull() || val.isError()) {
            return -1;
        }
        if (val.isNumeric()) {
            return val.toInt();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getBridgePort: mac/bridgeport: " + this.m_mac + "/" + val.toDisplayString()));
        }
        return -1;
    }

    public int getQBridgePort() {
        Category log = ThreadCategory.getInstance(this.getClass());
        SnmpValue val = SnmpUtils.get((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId)this.getOid(QFDB_PORT_OID));
        if (val == null) {
            return -1;
        }
        if (val.isNull() || val.isError()) {
            return -1;
        }
        if (val.isNumeric()) {
            return val.toInt();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getQBridgePort: mac/bridgeport: " + this.m_mac + "/" + val.toDisplayString()));
        }
        return -1;
    }

    public int getBridgePortStatus() {
        Category log = ThreadCategory.getInstance(this.getClass());
        SnmpValue val = SnmpUtils.get((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId)this.getOid(FDB_STATUS_OID));
        if (val == null) {
            return -1;
        }
        if (val.isNull() || val.isError()) {
            return -1;
        }
        if (val.isNumeric()) {
            return val.toInt();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getBridgePortStatus: mac/bridgeport: " + this.m_mac + "/" + val.toDisplayString()));
        }
        return -1;
    }

    public int getQBridgePortStatus() {
        Category log = ThreadCategory.getInstance(this.getClass());
        SnmpValue val = SnmpUtils.get((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId)this.getOid(QFDB_STATUS_OID));
        if (val == null) {
            return -1;
        }
        if (val.isNull() || val.isError()) {
            return -1;
        }
        if (val.isNumeric()) {
            return val.toInt();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getQBridgePortStatus: mac/bridgeport: " + this.m_mac + "/" + val.toDisplayString()));
        }
        return -1;
    }

    private SnmpObjId getOid(String oid) {
        return SnmpObjId.get((String)(oid + "." + this.m_mac));
    }

    private String getInstanceString(String mac) {
        return Integer.parseInt(mac.substring(0, 2), 16) + "." + Integer.parseInt(mac.substring(2, 4), 16) + "." + Integer.parseInt(mac.substring(4, 6), 16) + "." + Integer.parseInt(mac.substring(6, 8), 16) + "." + Integer.parseInt(mac.substring(8, 10), 16) + "." + Integer.parseInt(mac.substring(10, 12), 16);
    }
}

