/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.jmx;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.LinkdConfigFactory;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.linkd.DbEventWriter;
import org.opennms.netmgt.linkd.jmx.LinkdMBean;

public class Linkd
implements LinkdMBean {
    public static final String LOG4J_CATEGORY = "OpenNMS.Linkd";

    public void init() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        try {
            LinkdConfigFactory.init();
            DataSourceFactory.init();
        }
        catch (ClassNotFoundException ex) {
            this.log().error((Object)"init: Failed to load configuration file ", (Throwable)ex);
        }
        catch (MarshalException ex) {
            this.log().error((Object)"Failed to load configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().error((Object)"Failed to load configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().error((Object)"Failed to load configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (PropertyVetoException pve) {
            this.log().fatal((Object)"Property veto failure loading database config", (Throwable)pve);
            throw new UndeclaredThrowableException(pve);
        }
        catch (SQLException sqle) {
            this.log().fatal((Object)"SQL exception loading database config", (Throwable)sqle);
            throw new UndeclaredThrowableException(sqle);
        }
        EventIpcManagerFactory.init();
        EventIpcManager mgr = EventIpcManagerFactory.getIpcManager();
        org.opennms.netmgt.linkd.Linkd linkd = this.getLinkd();
        linkd.setEventMgr(mgr);
        linkd.setDbConnectionFactory(DataSourceFactory.getInstance());
        linkd.setLinkdConfig(LinkdConfigFactory.getInstance());
        linkd.setQueryManager(new DbEventWriter(DataSourceFactory.getDataSource()));
        linkd.init();
    }

    public void start() {
        this.getLinkd().start();
    }

    public void stop() {
        this.getLinkd().stop();
    }

    public int getStatus() {
        return this.getLinkd().getStatus();
    }

    public String status() {
        return Fiber.STATUS_NAMES[this.getStatus()];
    }

    public String getStatusText() {
        return Fiber.STATUS_NAMES[this.getStatus()];
    }

    private Category log() {
        return ThreadCategory.getInstance();
    }

    private org.opennms.netmgt.linkd.Linkd getLinkd() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return org.opennms.netmgt.linkd.Linkd.getInstance();
    }
}

