/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;

public class RouterInterface {
    int ifindex;
    int metric;
    InetAddress routedest;
    InetAddress routemask;
    InetAddress nextHop;
    int nextHopnodeid;
    int nextHopIfindex;
    InetAddress nextHopNetmask;
    int snmpiftype;

    RouterInterface(int nextHopnodeid, int nextHopIfindex, String nextHopNetmask) {
        this.nextHopnodeid = nextHopnodeid;
        this.nextHopIfindex = nextHopIfindex;
        try {
            this.nextHopNetmask = InetAddress.getByName(nextHopNetmask);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    RouterInterface(int nextHopnodeid, int nextHopIfindex) {
        this.nextHopnodeid = nextHopnodeid;
        this.nextHopIfindex = nextHopIfindex;
        try {
            this.nextHopNetmask = InetAddress.getByName("255.255.255.255");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getIfindex() {
        return this.ifindex;
    }

    public int getMetric() {
        return this.metric;
    }

    public void setMetric(int metric) {
        this.metric = metric;
    }

    public InetAddress getNextHop() {
        return this.nextHop;
    }

    public void setNextHop(InetAddress nextHop) {
        this.nextHop = nextHop;
    }

    public int getSnmpiftype() {
        return this.snmpiftype;
    }

    public void setSnmpiftype(int snmpiftype) {
        this.snmpiftype = snmpiftype;
    }

    public InetAddress getNetmask() {
        return this.nextHopNetmask;
    }

    public void setNetmask(InetAddress netmask) {
        this.nextHopNetmask = netmask;
    }

    public int getNextHopNodeid() {
        return this.nextHopnodeid;
    }

    public void setNextHopNodeid(int nexhopnodeid) {
        this.nextHopnodeid = nexhopnodeid;
    }

    public int getNextHopIfindex() {
        return this.nextHopIfindex;
    }

    public void setNextHopIfindex(int nextHopIfindex) {
        this.nextHopIfindex = nextHopIfindex;
    }

    public void setIfindex(int ifindex) {
        this.ifindex = ifindex;
    }

    public InetAddress getNextHopNet() {
        byte[] ipAddress = this.nextHop.getAddress();
        byte[] netMask = this.nextHopNetmask.getAddress();
        byte[] netWork = new byte[4];
        for (int i = 0; i < 4; ++i) {
            netWork[i] = new Integer(ipAddress[i] & netMask[i]).byteValue();
        }
        try {
            return InetAddress.getByAddress(netWork);
        }
        catch (Exception e) {
            return null;
        }
    }

    public InetAddress getRouteNet() {
        byte[] ipAddress = this.routedest.getAddress();
        byte[] netMask = this.routemask.getAddress();
        byte[] netWork = new byte[4];
        for (int i = 0; i < 4; ++i) {
            netWork[i] = new Integer(ipAddress[i] & netMask[i]).byteValue();
        }
        try {
            return InetAddress.getByAddress(netWork);
        }
        catch (Exception e) {
            return null;
        }
    }

    public InetAddress getRouteDest() {
        return this.routedest;
    }

    public void setRouteDest(InetAddress routedest) {
        this.routedest = routedest;
    }

    public InetAddress getRoutemask() {
        return this.routemask;
    }

    public void setRoutemask(InetAddress routemask) {
        this.routemask = routemask;
    }

    public String toString() {
        String stringa = "";
        stringa = stringa + "routedest = " + this.routedest + "\n";
        stringa = stringa + "routemask = " + this.routemask + "\n";
        stringa = stringa + "routeifindex = " + this.ifindex + "\n";
        stringa = stringa + "routemetric = " + this.metric + "\n";
        stringa = stringa + "nexthop = " + this.nextHop + "\n";
        stringa = stringa + "nexthopmask = " + this.nextHopNetmask + "\n";
        stringa = stringa + "nexthopnodeid = " + this.nextHopnodeid + "\n";
        stringa = stringa + "nexthopifindex = " + this.nextHopIfindex + "\n";
        stringa = stringa + "snmpiftype = " + this.snmpiftype + "\n";
        stringa = stringa + "routenet = " + this.getRouteNet() + "\n";
        stringa = stringa + "nexthopnet = " + this.getNextHopNet() + "\n";
        return stringa;
    }
}

