/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.db;

import java.util.Iterator;
import java.util.List;

public class Constants {
    public static final int SEV_INDETERMINATE = 1;
    public static final int SEV_CLEARED = 2;
    public static final int SEV_NORMAL = 3;
    public static final int SEV_WARNING = 4;
    public static final int SEV_MINOR = 5;
    public static final int SEV_MAJOR = 6;
    public static final int SEV_CRITICAL = 7;
    static final int STATE_ON = 1;
    static final int STATE_OFF = 0;
    static final char NAME_VAL_DELIM = '=';
    static final char MULTIPLE_VAL_DELIM = ';';
    static final String ATTRIB_DELIM = "/\\";
    static final char DB_ATTRIB_DELIM = ',';
    static final String VALUE_TRUNCATE_INDICATOR = "...";

    public static String escape(String inStr, char delimchar) {
        StringBuilder buf = new StringBuilder(inStr.length() + 16);
        for (char ch : inStr.toCharArray()) {
            if (ch == delimchar || Character.isISOControl(ch) && !Character.isWhitespace(ch)) {
                buf.append('%');
                buf.append(String.valueOf((int)ch));
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String format(List strings, int maxlen) {
        if (strings == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        Iterator i = strings.iterator();
        while (i.hasNext() && buf.length() < maxlen) {
            String s = (String)i.next();
            s = Constants.escape(s, ';');
            if (!first) {
                buf.append(';');
            }
            buf.append(s);
            first = false;
        }
        if (buf.length() >= maxlen) {
            buf.setLength(maxlen - 4);
            buf.append(VALUE_TRUNCATE_INDICATOR);
        }
        return buf.toString();
    }

    public static String format(String[] strings, int maxlen) {
        if (strings == null || strings.length <= 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (int index = 0; index < strings.length && buf.length() < maxlen; ++index) {
            String s = strings[index];
            s = Constants.escape(s, ';');
            if (!first) {
                buf.append(';');
            }
            buf.append(s);
            first = false;
        }
        if (buf.length() >= maxlen) {
            buf.setLength(maxlen - 4);
            buf.append(VALUE_TRUNCATE_INDICATOR);
        }
        return buf.toString();
    }

    public static String format(String origString, int maxlen) {
        if (origString == null) {
            return null;
        }
        String escapedString = Constants.escape(origString, '\u0000');
        if (escapedString.length() >= maxlen) {
            StringBuffer buf = new StringBuffer(escapedString);
            buf.setLength(maxlen - 4);
            buf.append(VALUE_TRUNCATE_INDICATOR);
            return buf.toString();
        }
        return escapedString;
    }

    public static int getSeverity(String sev) {
        int rc = 1;
        if (sev != null) {
            if ((sev = sev.trim()).equalsIgnoreCase("normal")) {
                rc = 3;
            } else if (sev.equalsIgnoreCase("warning")) {
                rc = 4;
            } else if (sev.equalsIgnoreCase("minor")) {
                rc = 5;
            } else if (sev.equalsIgnoreCase("major")) {
                rc = 6;
            } else if (sev.equalsIgnoreCase("critical")) {
                rc = 7;
            } else if (sev.equalsIgnoreCase("cleared")) {
                rc = 2;
            }
        }
        return rc;
    }

    public static String getSeverityString(int sev) {
        String retString = null;
        switch (sev) {
            case 2: {
                retString = "Cleared";
                break;
            }
            case 7: {
                retString = "Critical";
                break;
            }
            case 6: {
                retString = "Major";
                break;
            }
            case 5: {
                retString = "Minor";
                break;
            }
            case 3: {
                retString = "Normal";
                break;
            }
            case 4: {
                retString = "Warning";
                break;
            }
            default: {
                retString = "Indeterminate";
            }
        }
        return retString;
    }
}

