/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.eventd.AlarmWriter;
import org.opennms.netmgt.eventd.EventWriter;
import org.opennms.netmgt.eventd.Eventd;
import org.opennms.netmgt.eventd.db.AutoAction;
import org.opennms.netmgt.eventd.db.Constants;
import org.opennms.netmgt.eventd.db.Correlation;
import org.opennms.netmgt.eventd.db.Forward;
import org.opennms.netmgt.eventd.db.OperatorAction;
import org.opennms.netmgt.eventd.db.Parameter;
import org.opennms.netmgt.eventd.db.SnmpInfo;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Header;
import org.opennms.netmgt.xml.event.Operaction;

class Persist {
    private static final int EVENT_UEI_FIELD_SIZE = 256;
    private static final int EVENT_HOST_FIELD_SIZE = 256;
    private static final int EVENT_INTERFACE_FIELD_SIZE = 16;
    private static final int EVENT_DPNAME_FIELD_SIZE = 12;
    private static final int EVENT_SNMPHOST_FIELD_SIZE = 256;
    private static final int EVENT_SNMP_FIELD_SIZE = 256;
    private static final int EVENT_DESCR_FIELD_SIZE = 4000;
    private static final int EVENT_LOGGRP_FIELD_SIZE = 32;
    private static final int EVENT_LOGMSG_FIELD_SIZE = 256;
    private static final int EVENT_PATHOUTAGE_FIELD_SIZE = 1024;
    private static final int EVENT_CORRELATION_FIELD_SIZE = 1024;
    private static final int EVENT_OPERINSTRUCT_FIELD_SIZE = 1024;
    private static final int EVENT_AUTOACTION_FIELD_SIZE = 256;
    private static final int EVENT_OPERACTION_FIELD_SIZE = 256;
    private static final int EVENT_OPERACTION_MENU_FIELD_SIZE = 64;
    private static final int EVENT_TTICKET_FIELD_SIZE = 128;
    private static final int EVENT_FORWARD_FIELD_SIZE = 256;
    private static final int EVENT_MOUSEOVERTEXT_FIELD_SIZE = 64;
    private static final int EVENT_ACKUSER_FIELD_SIZE = 256;
    private static final int EVENT_SOURCE_FIELD_SIZE = 128;
    private static final int EVENT_X733_ALARMTYPE_SIZE = 31;
    private static char MSG_YES = (char)89;
    private static char MSG_NO = (char)78;
    protected Connection m_dsConn = DataSourceFactory.getInstance().getConnection();
    protected PreparedStatement m_getSvcIdStmt;
    protected PreparedStatement m_getHostNameStmt;
    protected PreparedStatement m_getNextIdStmt;
    protected PreparedStatement m_insStmt;
    protected PreparedStatement m_reductionQuery;
    protected PreparedStatement m_upDateStmt;
    protected PreparedStatement m_updateEventStmt;

    private void set(PreparedStatement stmt, int ndx, String value) throws SQLException {
        if (value == null || value.length() == 0) {
            stmt.setNull(ndx, 12);
        } else {
            stmt.setString(ndx, value);
        }
    }

    private void set(PreparedStatement stmt, int ndx, int value) throws SQLException {
        if (value < 0) {
            stmt.setNull(ndx, 4);
        } else {
            stmt.setInt(ndx, value);
        }
    }

    private void set(PreparedStatement stmt, int ndx, Timestamp value) throws SQLException {
        if (value == null) {
            stmt.setNull(ndx, 93);
        } else {
            stmt.setTimestamp(ndx, value);
        }
    }

    private void set(PreparedStatement stmt, int ndx, char value) throws SQLException {
        stmt.setString(ndx, String.valueOf(value));
    }

    private int getServiceID(String name) throws SQLException {
        if (name == null) {
            throw new NullPointerException("The service name was null");
        }
        int id = Eventd.getServiceID(name);
        if (id != -1) {
            return id;
        }
        this.m_getSvcIdStmt.setString(1, name);
        ResultSet rset = null;
        try {
            rset = this.m_getSvcIdStmt.executeQuery();
            if (rset.next()) {
                id = rset.getInt(1);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            rset.close();
        }
        if (id != -1) {
            Eventd.addServiceMapping(name, id);
        }
        return id;
    }

    private String getHostName(String hostip) throws SQLException {
        String hostname = hostip;
        this.m_getHostNameStmt.setString(1, hostip);
        ResultSet rset = null;
        try {
            rset = this.m_getHostNameStmt.executeQuery();
            if (rset.next()) {
                hostname = rset.getString(1);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            rset.close();
        }
        if (hostname == null) {
            hostname = hostip;
        }
        return hostname;
    }

    public void insertOrUpdateAlarm(Header eventHeader, Event event) throws SQLException {
        int alarmId = this.isReductionNeeded(eventHeader, event);
        if (alarmId != -1) {
            this.log().debug((Object)("AlarmWriter is reducing event for: " + event.getDbid() + ": " + event.getUei()));
            this.updateAlarm(eventHeader, event, alarmId);
            this.log().debug((Object)("insertOrUpdate: auto-clean is: " + event.getAlarmData().getAutoClean()));
            if (event.getAlarmData().getAutoClean()) {
                this.log().debug((Object)"insertOrUpdate: deleting previous events.");
                this.cleanPreviousEvents(alarmId, event.getDbid());
            }
        } else {
            this.log().debug((Object)("AlarmWriter is not reducing event for: " + event.getDbid() + ": " + event.getUei()));
            this.insertAlarm(eventHeader, event);
        }
    }

    private void cleanPreviousEvents(int alarmId, int eventId) {
        PreparedStatement stmt = null;
        try {
            stmt = this.m_dsConn.prepareStatement("DELETE FROM events WHERE alarmId = ? AND eventId != ?");
            stmt.setInt(1, alarmId);
            stmt.setInt(2, eventId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.log().error((Object)"cleanPreviousEvents: Couldn't remove old events.", (Throwable)e);
        }
        try {
            stmt.close();
        }
        catch (SQLException e) {
            this.log().error((Object)"cleanPreviousEvents: Couldn't close statement.", (Throwable)e);
        }
    }

    private Category log() {
        Category log = ThreadCategory.getInstance(AlarmWriter.class);
        return log;
    }

    private int isReductionNeeded(Header eventHeader, Event event) throws SQLException {
        int alarmId;
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Persist.isReductionNeeded: reductionKey: " + event.getAlarmData().getReductionKey()));
        }
        this.m_reductionQuery.setString(1, event.getAlarmData().getReductionKey());
        ResultSet rs = null;
        try {
            rs = this.m_reductionQuery.executeQuery();
            alarmId = -1;
            while (rs.next()) {
                alarmId = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            rs.close();
        }
        return alarmId;
    }

    private void updateAlarm(Header eventHeader, Event event, int alarmId) throws SQLException {
        Category log = ThreadCategory.getInstance(Persist.class);
        this.m_upDateStmt.setInt(1, event.getDbid());
        Timestamp eventTime = this.getEventTime(event, log);
        this.m_upDateStmt.setTimestamp(2, eventTime);
        this.m_upDateStmt.setString(3, event.getAlarmData().getReductionKey());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Persist.updateAlarm: reducing event: " + event.getDbid() + "into alarm: "));
        }
        this.m_upDateStmt.executeUpdate();
        this.m_updateEventStmt.setInt(1, alarmId);
        this.m_updateEventStmt.setInt(2, event.getDbid());
        this.m_updateEventStmt.executeUpdate();
    }

    private void insertAlarm(Header eventHeader, Event event) throws SQLException {
        int alarmID = -1;
        Category log = ThreadCategory.getInstance(AlarmWriter.class);
        alarmID = this.getNextId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("AlarmWriter: DBID: " + alarmID));
        }
        this.m_insStmt.setInt(1, alarmID);
        this.m_insStmt.setString(2, Constants.format(event.getUei(), 256));
        this.m_insStmt.setString(3, eventHeader != null ? Constants.format(eventHeader.getDpName(), 12) : "undefined");
        int nodeid = (int)event.getNodeid();
        this.m_insStmt.setObject(4, event.hasNodeid() ? new Integer(nodeid) : null);
        this.m_insStmt.setString(5, event.getInterface());
        int svcId = -1;
        if (event.getService() != null) {
            try {
                svcId = this.getServiceID(event.getService());
            }
            catch (SQLException sqlE) {
                log.warn((Object)("AlarmWriter.insertAlarm: Error converting service name \"" + event.getService() + "\" to an integer identifier, storing -1"), (Throwable)sqlE);
            }
        }
        this.m_insStmt.setObject(6, svcId == -1 ? null : new Integer(svcId));
        this.m_insStmt.setString(7, event.getAlarmData().getReductionKey());
        this.m_insStmt.setInt(8, event.getAlarmData().getAlarmType());
        this.m_insStmt.setInt(9, 1);
        this.set(this.m_insStmt, 10, Constants.getSeverity(event.getSeverity()));
        this.m_insStmt.setInt(11, event.getDbid());
        Timestamp eventTime = this.getEventTime(event, log);
        this.m_insStmt.setTimestamp(12, eventTime);
        this.m_insStmt.setTimestamp(13, eventTime);
        this.set(this.m_insStmt, 14, Constants.format(event.getDescr(), 4000));
        if (event.getLogmsg() != null) {
            this.set(this.m_insStmt, 15, Constants.format(event.getLogmsg().getContent(), 256));
        } else {
            this.m_insStmt.setNull(15, 12);
        }
        this.set(this.m_insStmt, 16, Constants.format(event.getOperinstruct(), 1024));
        if (event.getTticket() != null) {
            this.set(this.m_insStmt, 17, Constants.format(event.getTticket().getContent(), 128));
            int ttstate = 0;
            if (event.getTticket().getState().equals("on")) {
                ttstate = 1;
            }
            this.set(this.m_insStmt, 18, ttstate);
        } else {
            this.m_insStmt.setNull(17, 12);
            this.m_insStmt.setNull(18, 4);
        }
        this.set(this.m_insStmt, 19, Constants.format(event.getMouseovertext(), 64));
        this.set(this.m_insStmt, 20, eventTime);
        this.m_insStmt.setString(21, null);
        this.set(this.m_insStmt, 22, eventTime);
        this.m_insStmt.setString(23, null);
        this.m_insStmt.setTimestamp(24, null);
        if (event.getAlarmData() == null) {
            this.m_insStmt.setString(25, null);
            this.m_insStmt.setString(26, null);
            this.m_insStmt.setInt(27, -1);
            this.m_insStmt.setString(28, null);
        } else {
            this.m_insStmt.setString(25, Constants.format(event.getAlarmData().getClearUei(), 256));
            this.m_insStmt.setString(26, Constants.format(event.getAlarmData().getX733AlarmType(), 31));
            this.set(this.m_insStmt, 27, event.getAlarmData().getX733ProbableCause());
            this.set(this.m_insStmt, 28, event.getAlarmData().getClearKey());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("m_insStmt is: " + this.m_insStmt.toString()));
        }
        this.m_insStmt.executeUpdate();
        this.m_updateEventStmt.setInt(1, alarmID);
        this.m_updateEventStmt.setInt(2, event.getDbid());
        this.m_updateEventStmt.executeUpdate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("SUCCESSFULLY added " + event.getUei() + " related  data into the ALARMS table"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertEvent(Header eventHeader, Event event) throws SQLException {
        Category log = ThreadCategory.getInstance(EventWriter.class);
        int eventID = this.getNextId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("EventWriter: DBID: " + eventID));
        }
        Event event2 = event;
        synchronized (event2) {
            event.setDbid(eventID);
        }
        this.m_insStmt.setInt(1, eventID);
        this.m_insStmt.setString(2, Constants.format(event.getUei(), 256));
        int nodeid = (int)event.getNodeid();
        this.set(this.m_insStmt, 3, event.hasNodeid() ? nodeid : -1);
        Timestamp eventTime = this.getEventTime(event, log);
        this.m_insStmt.setTimestamp(4, eventTime);
        String hostname = this.getEventHost(event);
        this.set(this.m_insStmt, 5, Constants.format(hostname, 256));
        this.set(this.m_insStmt, 6, Constants.format(event.getInterface(), 16));
        this.m_insStmt.setString(7, eventHeader != null ? Constants.format(eventHeader.getDpName(), 12) : "undefined");
        this.set(this.m_insStmt, 8, Constants.format(event.getSnmphost(), 256));
        int svcId = this.getEventServiceId(event, log);
        this.set(this.m_insStmt, 9, svcId);
        if (event.getSnmp() != null) {
            this.m_insStmt.setString(10, SnmpInfo.format(event.getSnmp(), 256));
        } else {
            this.m_insStmt.setNull(10, 12);
        }
        this.set(this.m_insStmt, 11, event.getParms() != null ? Parameter.format(event.getParms()) : null);
        if (event.getIfIndex() != null && event.getParms() != null) {
            Parameter.format(event.getParms());
        }
        Timestamp eventCreateTime = new Timestamp(new Date().getTime());
        this.m_insStmt.setTimestamp(12, eventCreateTime);
        this.set(this.m_insStmt, 13, Constants.format(event.getDescr(), 4000));
        this.set(this.m_insStmt, 14, event.getLoggroupCount() > 0 ? Constants.format(event.getLoggroup(), 32) : null);
        if (event.getLogmsg() != null) {
            this.set(this.m_insStmt, 15, Constants.format(event.getLogmsg().getContent(), 256));
            String logdest = event.getLogmsg().getDest();
            if (logdest.equals("logndisplay")) {
                this.set(this.m_insStmt, 16, MSG_YES);
                this.set(this.m_insStmt, 17, MSG_YES);
            } else if (logdest.equals("logonly")) {
                this.set(this.m_insStmt, 16, MSG_YES);
                this.set(this.m_insStmt, 17, MSG_NO);
            } else if (logdest.equals("displayonly")) {
                this.set(this.m_insStmt, 16, MSG_NO);
                this.set(this.m_insStmt, 17, MSG_YES);
            } else if (logdest.equals("suppress")) {
                this.set(this.m_insStmt, 16, MSG_NO);
                this.set(this.m_insStmt, 17, MSG_NO);
            }
        } else {
            this.m_insStmt.setNull(15, 12);
            this.set(this.m_insStmt, 16, MSG_YES);
            this.set(this.m_insStmt, 17, MSG_YES);
        }
        this.set(this.m_insStmt, 18, Constants.getSeverity(event.getSeverity()));
        this.set(this.m_insStmt, 19, event.getPathoutage() != null ? Constants.format(event.getPathoutage(), 1024) : null);
        this.set(this.m_insStmt, 20, event.getCorrelation() != null ? Correlation.format(event.getCorrelation(), 1024) : null);
        this.m_insStmt.setNull(21, 4);
        this.set(this.m_insStmt, 22, Constants.format(event.getOperinstruct(), 1024));
        this.set(this.m_insStmt, 23, event.getAutoactionCount() > 0 ? AutoAction.format(event.getAutoaction(), 256) : null);
        if (event.getOperactionCount() > 0) {
            ArrayList<Operaction> a = new ArrayList<Operaction>();
            ArrayList<String> b = new ArrayList<String>();
            Enumeration en = event.enumerateOperaction();
            while (en.hasMoreElements()) {
                Operaction eoa = (Operaction)en.nextElement();
                a.add(eoa);
                b.add(eoa.getMenutext());
            }
            this.set(this.m_insStmt, 24, OperatorAction.format(a, 256));
            this.set(this.m_insStmt, 25, Constants.format(b, 64));
        } else {
            this.m_insStmt.setNull(24, 12);
            this.m_insStmt.setNull(25, 12);
        }
        this.m_insStmt.setNull(26, 12);
        if (event.getTticket() != null) {
            this.set(this.m_insStmt, 27, Constants.format(event.getTticket().getContent(), 128));
            int ttstate = 0;
            if (event.getTticket().getState().equals("on")) {
                ttstate = 1;
            }
            this.set(this.m_insStmt, 28, ttstate);
        } else {
            this.m_insStmt.setNull(27, 12);
            this.m_insStmt.setNull(28, 4);
        }
        this.set(this.m_insStmt, 29, event.getForwardCount() > 0 ? Forward.format(event.getForward(), 256) : null);
        this.set(this.m_insStmt, 30, Constants.format(event.getMouseovertext(), 64));
        if (event.getAutoacknowledge() != null && event.getAutoacknowledge().getState().equals("on")) {
            this.set(this.m_insStmt, 31, Constants.format(event.getAutoacknowledge().getContent(), 256));
            this.set(this.m_insStmt, 32, eventCreateTime);
        } else {
            this.m_insStmt.setNull(31, 4);
            this.m_insStmt.setNull(32, 93);
        }
        this.set(this.m_insStmt, 33, Constants.format(event.getSource(), 128));
        this.m_insStmt.executeUpdate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("SUCCESSFULLY added " + event.getUei() + " related  data into the EVENTS table"));
        }
    }

    private int getEventServiceId(Event event, Category log) {
        int svcId = -1;
        if (event.getService() != null) {
            try {
                svcId = this.getServiceID(event.getService());
            }
            catch (SQLException sqlE) {
                log.warn((Object)("EventWriter.add: Error converting service name \"" + event.getService() + "\" to an integer identifier, storing -1"), (Throwable)sqlE);
            }
        }
        return svcId;
    }

    private String getEventHost(Event event) {
        String hostname = event.getHost();
        if (hostname != null) {
            try {
                hostname = this.getHostName(hostname);
            }
            catch (SQLException sqlE) {
                hostname = event.getHost();
            }
        }
        return hostname;
    }

    private Timestamp getEventTime(Event event, Category log) {
        Timestamp eventTime = null;
        try {
            Date date = EventConstants.parseToDate(event.getTime());
            eventTime = new Timestamp(date.getTime());
        }
        catch (ParseException pe) {
            log.warn((Object)("Failed to convert time " + event.getTime() + " to java.sql.Timestamp, Setting current time instead"), (Throwable)pe);
            eventTime = new Timestamp(new Date().getTime());
        }
        return eventTime;
    }

    public void close() {
        try {
            this.m_dsConn.close();
        }
        catch (SQLException e) {
            ThreadCategory.getInstance(EventWriter.class).warn((Object)"SQLException while closing database connection", (Throwable)e);
        }
    }

    private int getNextId() throws SQLException {
        int id;
        ResultSet rs = null;
        try {
            rs = this.m_getNextIdStmt.executeQuery();
            rs.next();
            id = rs.getInt(1);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        rs = null;
        return id;
    }
}

