/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.ping.PingResponseCallback;
import org.opennms.netmgt.utils.EventBuilder;
import org.opennms.protocols.icmp.ICMPEchoPacket;

public class DiscoveryPingResponseCallback
implements PingResponseCallback {
    static final String EVENT_SOURCE_VALUE = "OpenNMS.Discovery";

    public void handleResponse(InetAddress address, ICMPEchoPacket packet) {
        EventBuilder eb = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", EVENT_SOURCE_VALUE);
        eb.setInterface(address.getHostAddress());
        try {
            eb.setHost(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException uhE) {
            eb.setHost("unresolved.host");
            this.log().warn((Object)"Failed to resolve local hostname", (Throwable)uhE);
        }
        eb.addParam("RTT", packet.getReceivedTime() - packet.getSentTime());
        try {
            EventIpcManagerFactory.getIpcManager().sendNow(eb.getEvent());
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"Sent event: uei.opennms.org/internal/discovery/newSuspect");
            }
        }
        catch (Throwable t) {
            this.log().warn((Object)"run: unexpected throwable exception caught during send to middleware", t);
        }
    }

    public void handleTimeout(InetAddress address, ICMPEchoPacket packet) {
        this.log().debug((Object)("request timed out: " + address));
    }

    public void handleError(InetAddress address, ICMPEchoPacket packet, Throwable t) {
        this.log().debug((Object)("an error occurred pinging " + address), t);
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

