/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.ThreshdConfigManager;

public final class ThreshdConfigFactory
extends ThreshdConfigManager {
    private static ThreshdConfigFactory m_singleton = null;
    private static boolean m_loaded = false;

    private ThreshdConfigFactory(Reader rdr, String localServer, boolean verifyServer) throws IOException, MarshalException, ValidationException {
        super(rdr, localServer, verifyServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        OpennmsServerConfigFactory.init();
        boolean verifyServer = OpennmsServerConfigFactory.getInstance().verifyServer();
        String localServer = OpennmsServerConfigFactory.getInstance().getServerName();
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHD_CONFIG_FILE_NAME);
        ThreadCategory.getInstance(ThreshdConfigFactory.class).debug((Object)("init: config file path: " + cfgFile.getPath()));
        FileReader rdr = new FileReader(cfgFile);
        try {
            m_singleton = new ThreshdConfigFactory(rdr, localServer, verifyServer);
            m_loaded = true;
        }
        finally {
            rdr.close();
        }
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        ThreshdConfigFactory.init();
    }

    public void reloadXML() throws IOException, MarshalException, ValidationException {
        ThreshdConfigFactory.reload();
    }

    protected void saveXML(String xmlString) throws IOException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHD_CONFIG_FILE_NAME);
        FileWriter fileWriter = new FileWriter(cfgFile);
        fileWriter.write(xmlString);
        fileWriter.flush();
        fileWriter.close();
    }

    public static synchronized ThreshdConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }
}

