/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.SyslogdConfiguration;
import org.opennms.netmgt.config.syslogd.UeiList;

public final class SyslogdConfigFactory
implements SyslogdConfig {
    private static SyslogdConfig m_singleton = null;
    private SyslogdConfiguration m_config;
    private static boolean m_loaded = false;

    private SyslogdConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileInputStream cfgIn = new FileInputStream(configFile);
        this.m_config = (SyslogdConfiguration)Unmarshaller.unmarshal(SyslogdConfiguration.class, (Reader)new InputStreamReader(cfgIn));
        ((InputStream)cfgIn).close();
    }

    public SyslogdConfigFactory(Reader rdr) throws MarshalException, ValidationException {
        this.m_config = (SyslogdConfiguration)Unmarshaller.unmarshal(SyslogdConfiguration.class, (Reader)rdr);
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SYSLOGD_CONFIG_FILE_NAME);
        m_singleton = new SyslogdConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        SyslogdConfigFactory.init();
    }

    public static synchronized SyslogdConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(SyslogdConfig config) {
        m_singleton = config;
        m_loaded = true;
    }

    public synchronized int getSyslogPort() {
        return this.m_config.getConfiguration().getSyslogPort();
    }

    public synchronized boolean getNewSuspectOnMessage() {
        return this.m_config.getConfiguration().getNewSuspectOnMessage();
    }

    public synchronized String getForwardingRegexp() {
        return this.m_config.getConfiguration().getForwardingRegexp();
    }

    public synchronized int getMatchingGroupHost() {
        return this.m_config.getConfiguration().getMatchingGroupHost();
    }

    public synchronized int getMatchingGroupMessage() {
        return this.m_config.getConfiguration().getMatchingGroupMessage();
    }

    public synchronized UeiList getUeiList() {
        return this.m_config.getUeiList();
    }

    public synchronized HideMessage getHideMessages() {
        return this.m_config.getHideMessage();
    }
}

