/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.opennms.netmgt.config.Owner;
import org.opennms.netmgt.config.TimeInterval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwnedInterval
extends TimeInterval {
    private List<Owner> m_owners;

    public OwnedInterval(OwnedInterval owned) {
        this(owned.getOwners(), owned.getStart(), owned.getEnd());
    }

    public OwnedInterval(TimeInterval interval) {
        this(interval.getStart(), interval.getEnd());
    }

    public OwnedInterval(Owner owner, TimeInterval interval) {
        this(owner, interval.getStart(), interval.getEnd());
    }

    public OwnedInterval(List<Owner> owners, TimeInterval interval) {
        this(owners, interval.getStart(), interval.getEnd());
    }

    public OwnedInterval(Date start, Date end) {
        this(new ArrayList<Owner>(0), start, end);
    }

    public OwnedInterval(Owner owner, Date start, Date end) {
        this(Collections.singletonList(owner), start, end);
    }

    public OwnedInterval(List<Owner> owners, Date start, Date end) {
        super(start, end);
        this.m_owners = new ArrayList<Owner>(owners);
        Collections.sort(this.m_owners);
    }

    public List<Owner> getOwners() {
        return this.m_owners;
    }

    public void addOwner(Owner owner) {
        this.m_owners.add(owner);
        Collections.sort(this.m_owners);
    }

    public void removeOwner(Owner owner) {
        this.m_owners.remove(owner);
    }

    public void addOwners(List<Owner> owners) {
        this.m_owners.addAll(owners);
        Collections.sort(this.m_owners);
    }

    public void removeOwners(List<Owner> owners) {
        this.m_owners.removeAll(owners);
    }

    public boolean isOwner(Owner owner) {
        return this.m_owners.contains(owner);
    }

    public boolean isOwned() {
        return !this.m_owners.isEmpty();
    }

    @Override
    public String toString() {
        String ownerString = "";
        if (this.m_owners.isEmpty()) {
            ownerString = "UNOWNED";
        } else {
            for (int i = 0; i < this.m_owners.size(); ++i) {
                if (i != 0) {
                    ownerString = ownerString + ",";
                }
                ownerString = ownerString + this.m_owners.get(i);
            }
        }
        return ownerString + super.toString();
    }

    @Override
    public int hashCode() {
        return 123;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof OwnedInterval) {
            OwnedInterval owned = (OwnedInterval)o;
            return super.equals(owned) && ((Object)this.m_owners).equals(owned.m_owners);
        }
        return false;
    }
}

