/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.LinkdConfig;
import org.opennms.netmgt.config.LinkdConfigManager;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;

public final class LinkdConfigFactory
extends LinkdConfigManager {
    private static LinkdConfig m_singleton = null;
    private static boolean m_loaded = false;
    private long m_currentVersion = -1L;

    public LinkdConfigFactory(long currentVersion, Reader reader, String localServer, boolean verifyServer) throws MarshalException, ValidationException, IOException {
        super(reader, localServer, verifyServer);
        this.m_currentVersion = currentVersion;
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        OpennmsServerConfigFactory.init();
        OpennmsServerConfigFactory onmsSvrConfig = OpennmsServerConfigFactory.getInstance();
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.LINKD_CONFIG_FILE_NAME);
        LinkdConfigFactory.logStatic().debug((Object)("init: config file path: " + cfgFile.getPath()));
        FileReader reader = new FileReader(cfgFile);
        LinkdConfigFactory config = new LinkdConfigFactory(cfgFile.lastModified(), reader, onmsSvrConfig.getServerName(), onmsSvrConfig.verifyServer());
        reader.close();
        LinkdConfigFactory.setInstance(config);
    }

    private static Category logStatic() {
        return ThreadCategory.getInstance(LinkdConfigFactory.class);
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        LinkdConfigFactory.init();
        LinkdConfigFactory.getInstance().update();
    }

    protected synchronized void saveXml(String xml) throws IOException {
        if (xml != null) {
            long timestamp = System.currentTimeMillis();
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.LINKD_CONFIG_FILE_NAME);
            LinkdConfigFactory.logStatic().debug((Object)("saveXml: saving config file at " + timestamp + ": " + cfgFile.getPath()));
            FileWriter fileWriter = new FileWriter(cfgFile);
            fileWriter.write(xml);
            fileWriter.flush();
            fileWriter.close();
            LinkdConfigFactory.logStatic().debug((Object)("saveXml: finished saving config file: " + cfgFile.getPath()));
        }
    }

    public static synchronized LinkdConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(LinkdConfig instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    public synchronized void update() throws IOException, MarshalException, ValidationException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.LINKD_CONFIG_FILE_NAME);
        if (cfgFile.lastModified() > this.m_currentVersion) {
            this.m_currentVersion = cfgFile.lastModified();
            LinkdConfigFactory.logStatic().debug((Object)("init: config file path: " + cfgFile.getPath()));
            this.reloadXML(new FileReader(cfgFile));
            LinkdConfigFactory.logStatic().debug((Object)("init: finished loading config file: " + cfgFile.getPath()));
        }
    }
}

