/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.DefaultCapsdConfigManager;
import org.springframework.util.Assert;

public final class CapsdConfigFactory {
    private static CapsdConfig s_singleton = null;

    private CapsdConfigFactory() {
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (CapsdConfigFactory.isLoaded()) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.CAPSD_CONFIG_FILE_NAME);
        if (CapsdConfigFactory.log().isDebugEnabled()) {
            CapsdConfigFactory.log().debug((Object)("init: config file path: " + cfgFile.getPath()));
        }
        DefaultCapsdConfigManager capsdConfig = new DefaultCapsdConfigManager();
        capsdConfig.update();
        CapsdConfigFactory.setInstance(capsdConfig);
    }

    private static boolean isLoaded() {
        return s_singleton != null;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        s_singleton = null;
        CapsdConfigFactory.init();
    }

    public static synchronized CapsdConfig getInstance() {
        Assert.state((boolean)CapsdConfigFactory.isLoaded(), (String)"The factory has not been initialized");
        return s_singleton;
    }

    public static synchronized void setInstance(CapsdConfig instance) {
        s_singleton = instance;
    }

    private static Category log() {
        return ThreadCategory.getInstance(CapsdConfigFactory.class);
    }
}

