/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.SNMPCollectorEntry;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.model.RrdRepository;

final class NodeInfo
extends CollectionResource {
    private SNMPCollectorEntry m_entry;
    private int m_nodeId;

    public NodeInfo(NodeResourceType def, CollectionAgent agent) {
        super(def);
        this.m_nodeId = agent.getNodeId();
    }

    public int getType() {
        return -1;
    }

    public File getResourceDir(RrdRepository repository) {
        File rrdBaseDir = repository.getRrdBaseDir();
        File nodeRepo = new File(rrdBaseDir, String.valueOf(this.getCollectionAgent().getNodeId()));
        return nodeRepo;
    }

    public String toString() {
        return "Node[" + this.m_nodeId + ']';
    }

    public void setEntry(SNMPCollectorEntry nodeEntry) {
        this.m_entry = nodeEntry;
    }

    protected SNMPCollectorEntry getEntry() {
        return this.m_entry;
    }

    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }
}

