/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.JMXCollectorEntry;
import org.opennms.netmgt.collectd.JMXDataSource;
import org.opennms.netmgt.collectd.JMXNodeInfo;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.config.BeanInfo;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.JMXDataCollectionConfigFactory;
import org.opennms.netmgt.config.collectd.Attrib;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.utils.EventProxy;
import org.opennms.netmgt.utils.ParameterMap;
import org.opennms.protocols.jmx.connectors.ConnectionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JMXCollector
implements ServiceCollector {
    private static final String SQL_GET_NODEID = "SELECT nodeid FROM ipinterface WHERE ipaddr=? AND ismanaged!='D'";
    static String IF_MAP_KEY = "org.opennms.netmgt.collectd.JBossCollector.ifMap";
    private static final int MAX_DS_NAME_LENGTH = 19;
    private String m_rrdPath = null;
    private boolean useFriendlyName = false;
    static String NODE_INFO_KEY = "org.opennms.netmgt.collectd.JMXCollector.nodeInfo";
    static String MAX_VARS_PER_PDU_STORAGE_KEY = "org.opennms.netmgt.collectd.JMXCollector.maxVarsPerPdu";
    private String serviceName = null;

    public String serviceName() {
        return this.serviceName.toUpperCase();
    }

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    @Override
    public void initialize(Map parameters) {
        Category log = ThreadCategory.getInstance(this.getClass());
        try {
            JMXDataCollectionConfigFactory.init();
        }
        catch (MarshalException e) {
            log.fatal((Object)"initialize: Failed to load data collection configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            log.fatal((Object)"initialize: Failed to load data collection configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            log.fatal((Object)"initialize: Failed to load data collection configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        Connection ctest = null;
        try {
            DataSourceFactory.init();
            ctest = DataSourceFactory.getInstance().getConnection();
        }
        catch (IOException e) {
            log.fatal((Object)"initialize: IOException getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (MarshalException e) {
            log.fatal((Object)"initialize: Marshall Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            log.fatal((Object)"initialize: Validation Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            log.fatal((Object)"initialize: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (PropertyVetoException e) {
            log.fatal((Object)"initialize: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            log.fatal((Object)"initialize: Failed loading database driver.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            if (ctest != null) {
                try {
                    ctest.close();
                }
                catch (Throwable t) {
                    log.warn((Object)"initialize: an exception occured while closing the JDBC connection", t);
                }
            }
        }
        log.debug((Object)"initialize: successfully instantiated JNI interface to RRD.");
    }

    private void initRRD() {
        File f;
        Category log = ThreadCategory.getInstance(this.getClass());
        this.m_rrdPath = JMXDataCollectionConfigFactory.getInstance().getRrdRepository();
        if (this.m_rrdPath == null) {
            throw new RuntimeException("Configuration error, failed to retrieve path to RRD repository.");
        }
        if (this.m_rrdPath.endsWith(File.separator)) {
            this.m_rrdPath = this.m_rrdPath.substring(0, this.m_rrdPath.length() - File.separator.length());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("initialize: " + this.serviceName + " RRD file repository path: " + this.m_rrdPath));
        }
        if (!(f = new File(this.m_rrdPath)).isDirectory() && !f.mkdirs()) {
            throw new RuntimeException("Unable to create RRD file repository, path: " + this.m_rrdPath);
        }
        try {
            RrdUtils.initialize();
        }
        catch (RrdException e) {
            log.error((Object)"initialize: Unable to initialize RrdUtils", (Throwable)e);
            throw new RuntimeException("Unable to initialize RrdUtils", e);
        }
    }

    @Override
    public void release() {
    }

    @Override
    public void initialize(CollectionAgent agent, Map parameters) {
        Category log = ThreadCategory.getInstance(this.getClass());
        InetAddress ipAddr = (InetAddress)agent.getAddress();
        log.debug((Object)("initialize: " + this.m_rrdPath));
        if (this.m_rrdPath == null) {
            this.initRRD();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("initialize: InetAddress=" + ipAddr.getHostAddress()));
        }
        String collectionName = ParameterMap.getKeyedString(parameters, "collection", this.serviceName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("initialize: collectionName=" + collectionName));
        }
        Connection dbConn = null;
        try {
            dbConn = DataSourceFactory.getInstance().getConnection();
        }
        catch (SQLException e) {
            log.error((Object)"initialize: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        int nodeID = -1;
        PreparedStatement stmt = null;
        try {
            stmt = dbConn.prepareStatement(SQL_GET_NODEID);
            stmt.setString(1, ipAddr.getHostAddress());
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                nodeID = rs.getInt(1);
                if (rs.wasNull()) {
                    nodeID = -1;
                }
            } else {
                nodeID = -1;
            }
            rs.close();
        }
        catch (SQLException e) {
            log.error((Object)"initialize: SQL exception!!", (Throwable)e);
            throw new RuntimeException("SQL exception while attempting to retrieve node id for interface " + ipAddr.getHostAddress());
        }
        finally {
            try {
                stmt.close();
                dbConn.close();
            }
            catch (Exception e) {}
        }
        JMXNodeInfo nodeInfo = new JMXNodeInfo(nodeID);
        log.debug((Object)("nodeInfo: " + ipAddr.getHostAddress() + " " + nodeID + " " + agent));
        Map attrMap = JMXDataCollectionConfigFactory.getInstance().getAttributeMap(collectionName, this.serviceName, ipAddr.getHostAddress());
        nodeInfo.setAttributeMap(attrMap);
        HashMap dsList = this.buildDataSourceList(collectionName, attrMap);
        nodeInfo.setDsMap(dsList);
        nodeInfo.setMBeans(JMXDataCollectionConfigFactory.getInstance().getMBeanInfo(collectionName));
        agent.setAttribute(NODE_INFO_KEY, nodeInfo);
        agent.setAttribute("collectionName", collectionName);
        File repos = new File(this.m_rrdPath + File.separator + nodeID + File.separator + collectionName);
        if (!repos.exists()) {
            repos.mkdir();
        }
    }

    @Override
    public void release(CollectionAgent agent) {
    }

    public abstract ConnectionWrapper getMBeanServerConnection(Map var1, InetAddress var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int collect(CollectionAgent agent, EventProxy eproxy, Map<String, String> map) {
        Category log = ThreadCategory.getInstance(this.getClass());
        InetAddress ipaddr = (InetAddress)agent.getAddress();
        String collectionName = (String)agent.getAttribute("collectionName");
        JMXNodeInfo nodeInfo = (JMXNodeInfo)agent.getAttribute(NODE_INFO_KEY);
        HashMap mbeans = nodeInfo.getMBeans();
        String collDir = this.serviceName;
        ConnectionWrapper connection = null;
        log.debug((Object)("collect " + ipaddr.getHostAddress() + " " + nodeInfo.getNodeId() + " " + this.m_rrdPath));
        try {
            int retry = ParameterMap.getKeyedInteger(map, "retry", 3);
            String port = ParameterMap.getKeyedString(map, "port", null);
            String friendlyName = ParameterMap.getKeyedString(map, "friendly-name", port);
            connection = this.getMBeanServerConnection(map, ipaddr);
            if (connection == null) {
                int n = 2;
                return n;
            }
            MBeanServerConnection mbeanServer = connection.getMBeanServer();
            if (this.useFriendlyName) {
                collDir = friendlyName;
            }
            for (int attempts = 0; attempts <= retry; ++attempts) {
                try {
                    for (BeanInfo beanInfo : mbeans.values()) {
                        String objectName = beanInfo.getObjectName();
                        String excludeList = beanInfo.getExcludes();
                        String[] attrNames = beanInfo.getAttributeNames();
                        if (objectName.indexOf("*") == -1) {
                            log.debug((Object)(this.serviceName + " Collector - getAttributes: " + objectName + " #attributes: " + attrNames.length));
                            try {
                                ObjectName oName = new ObjectName(objectName);
                                if (!mbeanServer.isRegistered(oName)) continue;
                                AttributeList attrList = mbeanServer.getAttributes(oName, attrNames);
                                this.updateRRDs(objectName, collectionName, agent, attrList, collDir, null, null);
                            }
                            catch (InstanceNotFoundException e) {
                                log.error((Object)("Unable to retrieve attributes from " + objectName), (Throwable)e);
                            }
                            continue;
                        }
                        Set<ObjectName> mbeanSet = mbeanServer.queryNames(new ObjectName(objectName), null);
                        for (ObjectName oName : mbeanSet) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(this.serviceName + " Collector - getAttributesWC: " + oName + " #attributes: " + attrNames.length + " " + beanInfo.getKeyAlias()));
                            }
                            try {
                                if (excludeList == null) {
                                    if (!mbeanServer.isRegistered(oName)) continue;
                                    AttributeList attrList = mbeanServer.getAttributes(oName, attrNames);
                                    this.updateRRDs(objectName, collectionName, agent, attrList, collDir, oName.getKeyProperty(beanInfo.getKeyField()), beanInfo.getKeyAlias());
                                    continue;
                                }
                                String keyName = oName.getKeyProperty(beanInfo.getKeyField());
                                boolean found = false;
                                StringTokenizer st = new StringTokenizer(excludeList, ",");
                                while (st.hasMoreTokens()) {
                                    if (!keyName.equals(st.nextToken())) continue;
                                    found = true;
                                    break;
                                }
                                if (found || !mbeanServer.isRegistered(oName)) continue;
                                AttributeList attrList = mbeanServer.getAttributes(oName, attrNames);
                                this.updateRRDs(objectName, collectionName, agent, attrList, collDir, oName.getKeyProperty(beanInfo.getKeyField()), beanInfo.getKeyAlias());
                            }
                            catch (InstanceNotFoundException e) {
                                log.error((Object)("Error retrieving attributes for " + oName), (Throwable)e);
                            }
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    e.fillInStackTrace();
                    log.debug((Object)(this.serviceName + " Collector.collect: IOException while collect " + "address: " + agent.getAddress()), (Throwable)e);
                    continue;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error getting MBeanServer", (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return 1;
    }

    public boolean createRRD(String collectionName, InetAddress ipaddr, String directory, JMXDataSource ds, String collectionDir, String keyField) throws RrdException {
        String creator = "primary " + this.serviceName + " interface " + ipaddr.getHostAddress();
        int step = JMXDataCollectionConfigFactory.getInstance().getStep(collectionName);
        List rraList = JMXDataCollectionConfigFactory.getInstance().getRRAList(collectionName);
        File repos = new File(directory + File.separator + collectionDir);
        if (!repos.exists()) {
            repos.mkdir();
        }
        if (keyField == null) {
            return RrdUtils.createRRD((String)creator, (String)(directory + File.separator + collectionDir), (String)ds.getName(), (int)step, (String)ds.getType(), (int)ds.getHeartbeat(), (String)ds.getMin(), (String)ds.getMax(), (List)rraList);
        }
        if (keyField.equals("")) {
            return RrdUtils.createRRD((String)creator, (String)(directory + File.separator + collectionDir), (String)ds.getName(), (int)step, (String)ds.getType(), (int)ds.getHeartbeat(), (String)ds.getMin(), (String)ds.getMax(), (List)rraList);
        }
        return RrdUtils.createRRD((String)creator, (String)(directory + File.separator + collectionDir), (String)(keyField + "_" + ds.getName()), (int)step, (String)ds.getType(), (int)ds.getHeartbeat(), (String)ds.getMin(), (String)ds.getMax(), (List)rraList);
    }

    private boolean updateRRDs(String objectName, String collectionName, NetworkInterface iface, AttributeList attributeList, String collectionDir, String keyField, String substitutions) {
        Category log = ThreadCategory.getInstance(this.getClass());
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        JMXNodeInfo nodeInfo = (JMXNodeInfo)iface.getAttribute(NODE_INFO_KEY);
        boolean rrdError = false;
        log.debug((Object)"updateRRDs: processing node-level collection...");
        String nodeRepository = this.m_rrdPath + File.separator + String.valueOf(nodeInfo.getNodeId());
        HashMap dsMap = nodeInfo.getDsMap();
        try {
            for (int i = 0; i < attributeList.size(); ++i) {
                Attribute attribute = (Attribute)attributeList.get(i);
                JMXDataSource ds = (JMXDataSource)dsMap.get(objectName + "|" + attribute.getName());
                if (keyField == null) {
                    try {
                        this.createRRD(collectionName, ipaddr, nodeRepository, ds, collectionDir, null);
                        RrdUtils.updateRRD((String)ipaddr.getHostAddress(), (String)(nodeRepository + File.separator + collectionDir), (String)ds.getName(), (String)attribute.getValue().toString());
                    }
                    catch (Throwable e1) {}
                } else {
                    try {
                        String key = this.fixKey(keyField, ds.getName(), substitutions);
                        this.createRRD(collectionName, ipaddr, nodeRepository, ds, collectionDir, key);
                        if (key.equals("")) {
                            RrdUtils.updateRRD((String)ipaddr.getHostAddress(), (String)(nodeRepository + File.separator + collectionDir), (String)ds.getName(), (String)("" + attribute.getValue()));
                        } else {
                            RrdUtils.updateRRD((String)ipaddr.getHostAddress(), (String)(nodeRepository + File.separator + collectionDir), (String)(key + "_" + ds.getName()), (String)("" + attribute.getValue()));
                        }
                    }
                    catch (Throwable e1) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(1100L);
                    continue;
                }
                catch (Exception te) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            rrdError = true;
        }
        return rrdError;
    }

    private String fixKey(String key, String attrName, String substitutions) {
        String newKey = key;
        if (key.startsWith(File.separator)) {
            newKey = key.substring(1);
        }
        if (substitutions != null && substitutions.length() > 0) {
            StringTokenizer st = new StringTokenizer(substitutions, ",");
            while (st.hasMoreTokens()) {
                int index;
                String token = st.nextToken();
                if (!newKey.equals(token.substring(0, index = token.indexOf("|")))) continue;
                newKey = token.substring(index + 1);
            }
        }
        return newKey;
    }

    public String getRRDValue_isthis_used_(JMXDataSource ds, JMXCollectorEntry collectorEntry) throws IllegalArgumentException {
        Category log = ThreadCategory.getInstance(this.getClass());
        log.debug((Object)("getRRDValue: " + ds.getName()));
        if (ds.getOid() == null) {
            return null;
        }
        return (String)collectorEntry.get(collectorEntry + "|" + ds.getOid());
    }

    private HashMap buildDataSourceList(String collectionName, Map attributeMap) {
        Category log = ThreadCategory.getInstance(this.getClass());
        log.debug((Object)"buildDataSourceList - ***");
        HashMap<String, JMXDataSource> dsList = new HashMap<String, JMXDataSource>();
        log.debug((Object)("attributeMap size: " + attributeMap.size()));
        Iterator objNameIter = attributeMap.keySet().iterator();
        while (objNameIter.hasNext()) {
            String objectName = objNameIter.next().toString();
            log.debug((Object)("ObjectName: " + objectName));
            ArrayList list = (ArrayList)attributeMap.get(objectName);
            log.debug((Object)("Attributes: " + list.size()));
            for (Attrib attr : list) {
                JMXDataSource ds = null;
                String ds_type = JMXDataSource.mapType(attr.getType());
                if (ds_type != null) {
                    ds = new JMXDataSource();
                    ds.setHeartbeat(2 * JMXDataCollectionConfigFactory.getInstance().getStep(collectionName));
                    String ds_minval = attr.getMinval();
                    if (ds_minval == null) {
                        ds_minval = "U";
                    }
                    ds.setMax(ds_minval);
                    String ds_maxval = attr.getMaxval();
                    if (ds_maxval == null) {
                        ds_maxval = "U";
                    }
                    ds.setMax(ds_maxval);
                    ds.setInstance(collectionName);
                    String ds_name = attr.getAlias();
                    if (ds_name.length() > 19) {
                        if (log.isEnabledFor(Priority.WARN)) {
                            log.warn((Object)("buildDataSourceList: alias '" + attr.getAlias() + "' exceeds 19 char maximum for RRD data " + "source names, truncating."));
                        }
                        char[] temp = ds_name.toCharArray();
                        ds_name = String.copyValueOf(temp, 0, 19);
                    }
                    ds.setName(ds_name);
                    ds.setType(ds_type);
                    ds.setOid(attr.getName());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("buildDataSourceList: ds_name: " + ds.getName() + " ds_oid: " + ds.getOid() + "." + ds.getInstance() + " ds_max: " + ds.getMax() + " ds_min: " + ds.getMin()));
                    }
                    dsList.put(objectName + "|" + attr.getName(), ds);
                    continue;
                }
                if (!log.isEnabledFor(Priority.WARN)) continue;
                log.warn((Object)("buildDataSourceList: Data type '" + attr.getType() + "' not supported.  Only integer-type data may be " + "stored in RRD."));
                log.warn((Object)("buildDataSourceList: MBean object '" + attr.getAlias() + "' will not be mapped to RRD data source."));
            }
        }
        return dsList;
    }

    public void setUseFriendlyName(boolean useFriendlyName) {
        this.useFriendlyName = useFriendlyName;
    }
}

