/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opennms.netmgt.collectd.AttributeType;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.snmp.SnmpInstId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfResourceType
extends ResourceType {
    private TreeMap<Integer, IfInfo> m_ifMap = new TreeMap();

    public IfResourceType(CollectionAgent agent, OnmsSnmpCollection snmpCollection) {
        super(agent, snmpCollection);
        this.addKnownIfResources();
    }

    private Map<Integer, IfInfo> getIfMap() {
        return this.m_ifMap;
    }

    void addIfInfo(IfInfo ifInfo) {
        this.getIfMap().put(new Integer(ifInfo.getIndex()), ifInfo);
    }

    void addKnownIfResources() {
        Set<IfInfo> ifInfos = this.getAgent().getSnmpInterfaceInfo(this);
        for (IfInfo ifInfo : ifInfos) {
            this.addIfInfo(ifInfo);
        }
    }

    IfInfo getIfInfo(int ifIndex) {
        return this.getIfMap().get(new Integer(ifIndex));
    }

    public Collection<IfInfo> getIfInfos() {
        return this.getIfMap().values();
    }

    @Override
    public CollectionResource findResource(SnmpInstId inst) {
        return this.getIfInfo(inst.toInt());
    }

    @Override
    public CollectionResource findAliasedResource(SnmpInstId inst, String ifAlias) {
        this.log().debug((Object)"findAliasedResource: Should not get called from IfResourceType");
        return null;
    }

    public Collection<IfInfo> getResources() {
        return this.m_ifMap.values();
    }

    @Override
    protected Collection<AttributeType> loadAttributeTypes() {
        return this.getCollection().getIndexedAttributeTypesForResourceType(this.getAgent(), this);
    }
}

