/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.utils.ParameterMap;
import org.opennms.protocols.ntp.NtpMessage;

public final class NtpPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "NTP";
    private static final int DEFAULT_PORT = 123;
    private static final int DEFAULT_RETRY = 3;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServer(InetAddress nserver, int port, int retries, int timeout) {
        boolean isAServer = false;
        Category log = ThreadCategory.getInstance(this.getClass());
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            socket.setSoTimeout(timeout);
            byte[] data = new byte[512];
            for (int count = 0; count < retries && !isAServer; ++count) {
                try {
                    NtpMessage request = new NtpMessage();
                    byte[] buf = new NtpMessage().toByteArray();
                    DatagramPacket outpkt = new DatagramPacket(buf, buf.length, nserver, port);
                    socket.send(outpkt);
                    DatagramPacket inpkt = new DatagramPacket(data, data.length);
                    socket.receive(inpkt);
                    if (!inpkt.getAddress().equals(nserver)) continue;
                    NtpMessage msg = new NtpMessage(inpkt.getData());
                    isAServer = true;
                    continue;
                }
                catch (InterruptedIOException ex) {
                    // empty catch block
                }
            }
        }
        catch (IOException ex) {
            log.warn((Object)"isServer: An I/O exception during NTP resolution test.", (Throwable)ex);
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
        return isAServer;
    }

    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    public boolean isProtocolSupported(InetAddress address) {
        return this.isServer(address, 123, 3, 3000);
    }

    public boolean isProtocolSupported(InetAddress address, Map qualifiers) {
        boolean result;
        int port = 123;
        int timeout = 3000;
        int retries = 3;
        if (qualifiers != null) {
            port = ParameterMap.getKeyedInteger(qualifiers, "port", 123);
            timeout = ParameterMap.getKeyedInteger(qualifiers, "timeout", 3000);
            retries = ParameterMap.getKeyedInteger(qualifiers, "retries", 3);
        }
        if ((result = this.isServer(address, port, retries, timeout)) && qualifiers != null && !qualifiers.containsKey("port")) {
            qualifiers.put("port", new Integer(port));
        }
        return result;
    }
}

