/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.DataSourceFactory;

public final class DbIfServiceEntry {
    public static final char STATUS_UNMANAGED = 'U';
    public static final char STATUS_ACTIVE = 'A';
    public static final char STATUS_DELETED = 'D';
    public static final char STATUS_FORCED = 'F';
    public static final char STATUS_NOT_POLLED = 'N';
    public static final char STATUS_UNKNOWN = ' ';
    public static final char STATUS_SUSPEND = 'S';
    public static final char STATUS_RESUME = 'R';
    public static final char STATUS_REMOTE = 'X';
    static final char SOURCE_PLUGIN = 'P';
    static final char SOURCE_FORCED = 'F';
    static final char SOURCE_UNKNOWN = ' ';
    static final char NOTIFY_ON = 'Y';
    static final char NOTIFY_OFF = 'N';
    static final char NOTIFY_UNKNOWN = ' ';
    private static final String SQL_LOAD_REC = "SELECT ifIndex, lastGood, lastFail, qualifier, status, source, notify FROM ifServices WHERE nodeID = ? AND ipAddr = ? AND serviceID = ? AND status != 'D'";
    private boolean m_fromDb;
    private int m_nodeId;
    private InetAddress m_ipAddr;
    private int m_serviceId;
    private int m_ifIndex;
    private char m_status;
    private char m_source;
    private Timestamp m_lastFail;
    private Timestamp m_lastGood;
    private char m_notify;
    private String m_qualifier;
    private int m_changed;
    private static final int CHANGED_IFINDEX = 1;
    private static final int CHANGED_LASTGOOD = 2;
    private static final int CHANGED_LASTFAIL = 4;
    private static final int CHANGED_STATUS = 8;
    private static final int CHANGED_SOURCE = 16;
    private static final int CHANGED_NOTIFY = 32;
    private static final int CHANGED_QUALIFIER = 64;

    private void insert(Connection c) throws SQLException {
        int rc;
        if (this.m_fromDb) {
            throw new IllegalStateException("The record already exists in the database");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        StringBuffer names = new StringBuffer("INSERT INTO ifServices (nodeID,ipAddr,serviceID");
        StringBuffer values = new StringBuffer("?,?,?");
        if ((this.m_changed & 1) == 1) {
            values.append(",?");
            names.append(",ifIndex");
        }
        if ((this.m_changed & 8) == 8) {
            values.append(",?");
            names.append(",status");
        }
        if ((this.m_changed & 2) == 2) {
            values.append(",?");
            names.append(",lastGood");
        }
        if ((this.m_changed & 4) == 4) {
            values.append(",?");
            names.append(",lastFail");
        }
        if ((this.m_changed & 0x10) == 16) {
            values.append(",?");
            names.append(",source");
        }
        if ((this.m_changed & 0x20) == 32) {
            values.append(",?");
            names.append(",notify");
        }
        if ((this.m_changed & 0x40) == 64) {
            values.append(",?");
            names.append(",qualifier");
        }
        names.append(") VALUES (").append(values).append(')');
        if (log.isDebugEnabled()) {
            log.debug((Object)("DbIfServiceEntry.insert: SQL insert statment = " + names.toString()));
        }
        PreparedStatement stmt = c.prepareStatement(names.toString());
        names = null;
        int ndx = 1;
        stmt.setInt(ndx++, this.m_nodeId);
        stmt.setString(ndx++, this.m_ipAddr.getHostAddress());
        stmt.setInt(ndx++, this.m_serviceId);
        if ((this.m_changed & 1) == 1) {
            stmt.setInt(ndx++, this.m_ifIndex);
        }
        if ((this.m_changed & 8) == 8) {
            stmt.setString(ndx++, new String(new char[]{this.m_status}));
        }
        if ((this.m_changed & 2) == 2) {
            stmt.setTimestamp(ndx++, this.m_lastGood);
        }
        if ((this.m_changed & 4) == 4) {
            stmt.setTimestamp(ndx++, this.m_lastFail);
        }
        if ((this.m_changed & 0x10) == 16) {
            stmt.setString(ndx++, new String(new char[]{this.m_source}));
        }
        if ((this.m_changed & 0x20) == 32) {
            stmt.setString(ndx++, new String(new char[]{this.m_notify}));
        }
        if ((this.m_changed & 0x40) == 64) {
            stmt.setString(ndx++, this.m_qualifier);
        }
        try {
            rc = stmt.executeUpdate();
        }
        catch (SQLException e) {
            log.warn((Object)("ifServices DB insert got exception; will retry after deletion of any existing records for this ifService that are marked for deletion.  Exception: " + e.getMessage()), (Throwable)e);
            c.rollback();
            String delCmd = "DELETE FROM ifServices WHERE status = 'D' AND nodeid = ? AND ipAddr = ? AND serviceID = ?";
            PreparedStatement delStmt = c.prepareStatement(delCmd);
            delStmt.setInt(1, this.m_nodeId);
            delStmt.setString(2, this.m_ipAddr.getHostAddress());
            delStmt.setInt(3, this.m_serviceId);
            rc = delStmt.executeUpdate();
            delStmt.close();
            rc = stmt.executeUpdate();
        }
        log.debug((Object)("insert(): SQL update result = " + rc));
        stmt.close();
        this.m_fromDb = true;
        this.m_changed = 0;
    }

    private void update(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        StringBuffer sqlText = new StringBuffer("UPDATE ifServices SET ");
        int comma = 32;
        if ((this.m_changed & 1) == 1) {
            sqlText.append((char)comma).append("ifIndex = ?");
            comma = 44;
        }
        if ((this.m_changed & 8) == 8) {
            sqlText.append((char)comma).append("status = ?");
            comma = 44;
        }
        if ((this.m_changed & 2) == 2) {
            sqlText.append((char)comma).append("lastGood = ?");
            comma = 44;
        }
        if ((this.m_changed & 4) == 4) {
            sqlText.append((char)comma).append("lastFail = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x10) == 16) {
            sqlText.append((char)comma).append("source = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x20) == 32) {
            sqlText.append((char)comma).append("notify = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x40) == 64) {
            sqlText.append((char)comma).append("qualifier = ?");
            comma = 44;
        }
        sqlText.append(" WHERE nodeID = ? AND ipAddr = ? AND serviceID = ? and status <> 'D'");
        log.debug((Object)("DbIfServiceEntry.update: SQL update statment = " + sqlText.toString()));
        PreparedStatement stmt = c.prepareStatement(sqlText.toString());
        sqlText = null;
        int ndx = 1;
        if ((this.m_changed & 1) == 1) {
            if (this.m_ifIndex == -1) {
                stmt.setNull(ndx++, 4);
            } else {
                stmt.setInt(ndx++, this.m_ifIndex);
            }
        }
        if ((this.m_changed & 8) == 8) {
            if (this.m_status != ' ') {
                stmt.setString(ndx++, new String(new char[]{this.m_status}));
            } else {
                stmt.setNull(ndx++, 1);
            }
        }
        if ((this.m_changed & 2) == 2) {
            if (this.m_lastGood != null) {
                stmt.setTimestamp(ndx++, this.m_lastGood);
            } else {
                stmt.setNull(ndx++, 93);
            }
        }
        if ((this.m_changed & 4) == 4) {
            if (this.m_lastFail != null) {
                stmt.setTimestamp(ndx++, this.m_lastFail);
            } else {
                stmt.setNull(ndx++, 93);
            }
        }
        if ((this.m_changed & 0x10) == 16) {
            if (this.m_source == ' ') {
                stmt.setNull(ndx++, 1);
            } else {
                stmt.setString(ndx++, new String(new char[]{this.m_source}));
            }
        }
        if ((this.m_changed & 0x20) == 32) {
            if (this.m_notify == ' ') {
                stmt.setNull(ndx++, 1);
            } else {
                stmt.setString(ndx++, new String(new char[]{this.m_notify}));
            }
        }
        stmt.setInt(ndx++, this.m_nodeId);
        stmt.setString(ndx++, this.m_ipAddr.getHostAddress());
        stmt.setInt(ndx++, this.m_serviceId);
        int rc = stmt.executeUpdate();
        log.debug((Object)("DbIfServiceEntry.update: update result = " + rc));
        stmt.close();
        this.m_changed = 0;
    }

    private boolean load(Connection c) throws SQLException {
        String str;
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        PreparedStatement stmt = c.prepareStatement(SQL_LOAD_REC);
        stmt.setInt(1, this.m_nodeId);
        stmt.setString(2, this.m_ipAddr.getHostAddress());
        stmt.setInt(3, this.m_serviceId);
        ResultSet rset = stmt.executeQuery();
        if (!rset.next()) {
            rset.close();
            stmt.close();
            return false;
        }
        int ndx = 1;
        this.m_ifIndex = rset.getInt(ndx++);
        if (rset.wasNull()) {
            this.m_ifIndex = -1;
        }
        this.m_lastGood = rset.getTimestamp(ndx++);
        this.m_lastFail = rset.getTimestamp(ndx++);
        this.m_qualifier = rset.getString(ndx++);
        if (rset.wasNull()) {
            this.m_qualifier = null;
        }
        this.m_status = (str = rset.getString(ndx++)) != null && !rset.wasNull() ? str.charAt(0) : (char)32;
        str = rset.getString(ndx++);
        this.m_source = str != null && !rset.wasNull() ? str.charAt(0) : (char)32;
        str = rset.getString(ndx++);
        this.m_notify = str != null && !rset.wasNull() ? str.charAt(0) : (char)32;
        rset.close();
        stmt.close();
        this.m_changed = 0;
        return true;
    }

    private DbIfServiceEntry() {
        throw new UnsupportedOperationException("Default constructor not supported!");
    }

    private DbIfServiceEntry(int nid, InetAddress address, int sid, boolean exists) {
        this.m_fromDb = exists;
        this.m_nodeId = nid;
        this.m_ipAddr = address;
        this.m_serviceId = sid;
        this.m_ifIndex = -1;
        this.m_status = (char)32;
        this.m_lastGood = null;
        this.m_lastFail = null;
        this.m_source = (char)32;
        this.m_notify = (char)32;
        this.m_qualifier = null;
        this.m_changed = 0;
    }

    int getNodeId() {
        return this.m_nodeId;
    }

    InetAddress getIfAddress() {
        return this.m_ipAddr;
    }

    int getServiceId() {
        return this.m_serviceId;
    }

    String getLastGoodString() {
        String result = null;
        if (this.m_lastGood != null) {
            result = this.m_lastGood.toString();
        }
        return result;
    }

    Timestamp getLastGood() {
        return this.m_lastGood;
    }

    void setLastGood(String time) throws ParseException {
        if (time == null) {
            this.m_lastGood = null;
        } else {
            Date tmpDate = EventConstants.parseToDate(time);
            this.m_lastGood = new Timestamp(tmpDate.getTime());
        }
        this.m_changed |= 2;
    }

    void setLastGood(Date time) {
        this.m_lastGood = new Timestamp(time.getTime());
        this.m_changed |= 2;
    }

    void setLastGood(Timestamp time) {
        this.m_lastGood = time;
        this.m_changed |= 2;
    }

    String getLastFailString() {
        String result = null;
        if (this.m_lastFail != null) {
            result = this.m_lastFail.toString();
        }
        return result;
    }

    Timestamp getLastFail() {
        return this.m_lastFail;
    }

    void setLastFail(String time) throws ParseException {
        if (time == null) {
            this.m_lastFail = null;
        } else {
            Date tmpDate = EventConstants.parseToDate(time);
            this.m_lastFail = new Timestamp(tmpDate.getTime());
        }
        this.m_changed |= 4;
    }

    void setLastFail(Date time) {
        this.m_lastFail = new Timestamp(time.getTime());
        this.m_changed |= 4;
    }

    void setLastFail(Timestamp time) {
        this.m_lastFail = time;
        this.m_changed |= 4;
    }

    boolean hasIfIndex() {
        return this.m_ifIndex != -1;
    }

    int getIfIndex() {
        return this.m_ifIndex;
    }

    void setIfIndex(int ndx) {
        this.m_ifIndex = ndx;
        this.m_changed |= 1;
    }

    boolean hasIfIndexChanged() {
        return (this.m_changed & 1) == 1;
    }

    boolean updateIfIndex(int newIfIndex) {
        if (newIfIndex != this.m_ifIndex) {
            this.setIfIndex(newIfIndex);
            return true;
        }
        return false;
    }

    char getStatus() {
        return this.m_status;
    }

    void setStatus(char status) {
        this.m_status = status;
        this.m_changed |= 8;
    }

    boolean hasStatusChanged() {
        return (this.m_changed & 8) == 8;
    }

    boolean updateStatus(char newStatus) {
        if (newStatus != this.m_status) {
            this.setStatus(newStatus);
            return true;
        }
        return false;
    }

    char getSource() {
        return this.m_source;
    }

    void setSource(char src) {
        this.m_source = src;
        this.m_changed |= 0x10;
    }

    boolean hasSourceChanged() {
        return (this.m_changed & 0x10) == 16;
    }

    boolean updateSource(char newSource) {
        if (newSource != this.m_source) {
            this.setSource(newSource);
            return true;
        }
        return false;
    }

    char getNotify() {
        return this.m_notify;
    }

    void setNotify(char notify) {
        this.m_notify = notify;
        this.m_changed |= 0x20;
    }

    boolean hasNotifyChanged() {
        return (this.m_changed & 0x20) == 32;
    }

    boolean updateNotify(char newNotify) {
        if (newNotify != this.m_notify) {
            this.setNotify(newNotify);
            return true;
        }
        return false;
    }

    String getQualifier() {
        return this.m_qualifier;
    }

    void setQualifier(String qualifier) {
        this.m_qualifier = qualifier;
        this.m_changed |= 0x40;
    }

    boolean hasQualifierChanged() {
        return (this.m_changed & 0x40) == 64;
    }

    boolean updateQualifier(String newQualifier) {
        boolean doUpdate = false;
        if (newQualifier != null && this.m_qualifier != null) {
            if (!newQualifier.equals(this.m_qualifier)) {
                doUpdate = true;
            }
        } else if (newQualifier != null || this.m_qualifier != null) {
            doUpdate = true;
        }
        if (doUpdate) {
            this.setQualifier(newQualifier);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store() throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            Connection db = null;
            try {
                db = DataSourceFactory.getInstance().getConnection();
                this.store(db);
                if (!db.getAutoCommit()) {
                    db.commit();
                }
            }
            finally {
                try {
                    if (db != null) {
                        db.close();
                    }
                }
                catch (SQLException e) {
                    ThreadCategory.getInstance(this.getClass()).warn((Object)"Exception closing JDBC connection", (Throwable)e);
                }
            }
        }
    }

    void store(Connection db) throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            if (this.m_fromDb) {
                this.update(db);
            } else {
                this.insert(db);
            }
        }
    }

    static DbIfServiceEntry create(int nid, InetAddress address, int sid) {
        return new DbIfServiceEntry(nid, address, sid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DbIfServiceEntry get(int nid, InetAddress addr, int sid) throws SQLException {
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            DbIfServiceEntry dbIfServiceEntry = DbIfServiceEntry.get(db, nid, addr, sid);
            return dbIfServiceEntry;
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                ThreadCategory.getInstance(DbIfServiceEntry.class).warn((Object)"Exception closing JDBC connection", (Throwable)e);
            }
        }
    }

    static DbIfServiceEntry get(Connection db, int nid, InetAddress addr, int sid) throws SQLException {
        DbIfServiceEntry entry = new DbIfServiceEntry(nid, addr, sid, true);
        if (!entry.load(db)) {
            entry = null;
        }
        return entry;
    }

    public String toString() {
        String sep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("from db = ").append(this.m_fromDb).append(sep);
        buf.append("node id = ").append(this.m_nodeId).append(sep);
        buf.append("address = ").append(this.m_ipAddr).append(sep);
        buf.append("service id = ").append(this.m_serviceId).append(sep);
        buf.append("good time = ").append(this.m_lastGood).append(sep);
        buf.append("fail time = ").append(this.m_lastFail).append(sep);
        buf.append("status = ").append(this.m_status).append(sep);
        buf.append("ifIndex = ").append(this.m_ifIndex).append(sep);
        buf.append("source = ").append(this.m_source).append(sep);
        buf.append("notify = ").append(this.m_notify).append(sep);
        buf.append("qualifier = ").append(this.m_qualifier).append(sep);
        return buf.toString();
    }

    public static void main(String[] args) {
        try {
            DbIfServiceEntry entry = DbIfServiceEntry.get(Integer.parseInt(args[0]), InetAddress.getByName(args[1]), Integer.parseInt(args[2]));
            System.out.println(entry.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

