/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import org.opennms.core.concurrent.RunnableConsumerThreadPool;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.BroadcastEventProcessor;
import org.opennms.netmgt.capsd.CapsdDbSyncer;
import org.opennms.netmgt.capsd.EventProcessorFactory;
import org.opennms.netmgt.capsd.PluginManager;
import org.opennms.netmgt.capsd.RescanProcessor;
import org.opennms.netmgt.capsd.Scheduler;
import org.opennms.netmgt.capsd.SuspectEventProcessor;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;

public class Capsd
extends AbstractServiceDaemon {
    private static final String LOG4J_CATEGORY = "OpenNMS.Capsd";
    private static Object m_dbSyncLock = new Object();
    private static String m_address = null;
    private Scheduler m_scheduler = null;
    private EventProcessorFactory m_eventProcessorFactory;
    private BroadcastEventProcessor m_receiver;
    private RunnableConsumerThreadPool<SuspectEventProcessor> m_suspectRunner;
    private RunnableConsumerThreadPool<RescanProcessor> m_rescanRunner;
    private PluginManager m_pluginManager;
    private CapsdDbSyncer m_capsdDbSyncer;

    public Capsd() {
        super(LOG4J_CATEGORY);
    }

    protected void onStop() {
        this.m_receiver.close();
        this.m_suspectRunner.stop();
        this.m_rescanRunner.stop();
    }

    protected void onInit() {
        this.log().debug((Object)"init: Loading services into database...");
        this.getCapsdDbSyncer().syncServices();
        this.log().debug((Object)"init: Syncing management state...");
        this.getCapsdDbSyncer().syncManagementState();
        this.log().debug((Object)"init: Syncing primary SNMP interface state...");
        this.getCapsdDbSyncer().syncSnmpPrimaryState();
        this.m_suspectRunner = new RunnableConsumerThreadPool("Capsd Suspect Pool", 0.0f, 0.0f, CapsdConfigFactory.getInstance().getMaxSuspectThreadPoolSize());
        this.m_rescanRunner = new RunnableConsumerThreadPool("Capsd Rescan Pool", 0.0f, 0.0f, CapsdConfigFactory.getInstance().getMaxRescanThreadPoolSize());
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"init: Creating rescan scheduler");
        }
        try {
            this.m_scheduler = new Scheduler(this.getCapsdDbSyncer(), this.m_pluginManager, (FifoQueue<RescanProcessor>)this.m_rescanRunner.getRunQueue());
        }
        catch (SQLException sqlE) {
            this.log().error((Object)"Failed to initialize the rescan scheduler.", (Throwable)sqlE);
            throw new UndeclaredThrowableException(sqlE);
        }
        catch (Throwable t) {
            this.log().error((Object)"Failed to initialize the rescan scheduler.", t);
            throw new UndeclaredThrowableException(t);
        }
        this.log().debug((Object)"init: Creating event broadcast event receiver");
        try {
            this.m_receiver = new BroadcastEventProcessor((FifoQueue<SuspectEventProcessor>)this.m_suspectRunner.getRunQueue(), this.m_scheduler, this.m_eventProcessorFactory);
        }
        catch (Throwable t) {
            this.log().error((Object)"Failed to initialized the broadcast event receiver", t);
            throw new UndeclaredThrowableException(t);
        }
    }

    protected void onStart() {
        this.log().debug((Object)"start: Starting runnable thread pools...");
        this.m_suspectRunner.start();
        this.m_rescanRunner.start();
        this.log().debug((Object)"start: Starting rescan scheduler");
        this.m_scheduler.start();
    }

    protected void onPause() {
    }

    protected void onResume() {
    }

    public static String getLocalHostAddress() {
        return m_address;
    }

    static Object getDbSyncLock() {
        return m_dbSyncLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanSuspectInterface(String ifAddr) throws UnknownHostException {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            InetAddress addr = InetAddress.getByName(ifAddr);
            SuspectEventProcessor proc = this.m_eventProcessorFactory.createSuspectEventProcessor(addr.getHostAddress());
            proc.run();
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanInterfaceParent(Integer nodeId) {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            this.m_scheduler.forceRescan(nodeId);
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.m_pluginManager = pluginManager;
    }

    private CapsdDbSyncer getCapsdDbSyncer() {
        return this.m_capsdDbSyncer;
    }

    public void setCapsdDbSyncer(CapsdDbSyncer capsdDbSyncer) {
        this.m_capsdDbSyncer = capsdDbSyncer;
    }

    public void setEventProcessorFactory(EventProcessorFactory eventProcessorFactory) {
        this.m_eventProcessorFactory = eventProcessorFactory;
    }

    static {
        try {
            m_address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhE) {
            m_address = "localhost";
            ThreadCategory.getInstance((String)LOG4J_CATEGORY).warn((Object)"Could not lookup the host name for the local host machine, address set to localhost", (Throwable)uhE);
        }
    }
}

