/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Exp
extends PostfixMathCommand {
    public Exp() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e = stack.pop();
        stack.push(this.exp(e));
    }

    public Object exp(Object object) throws ParseException {
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            double d = complex.re();
            double d2 = complex.im();
            double d3 = Math.exp(d);
            return new Complex(d3 * Math.cos(d2), d3 * Math.sin(d2));
        }
        if (object instanceof Number) {
            return new Double(Math.exp(((Number)object).doubleValue()));
        }
        throw new ParseException("Invalid parameter type");
    }
}

