/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.webstart.poller;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Main {
    String[] m_args;
    ClassPathXmlApplicationContext m_context;
    PollerFrontEnd m_frontEnd;
    String m_url;
    String m_locationName;

    private Main(String[] args) {
        this.m_args = args;
    }

    private void run() {
        this.parseArguments();
        this.createAppContext();
        this.registerShutDownHook();
    }

    private void parseArguments() {
        if (this.m_args.length < 1) {
            this.usage();
        }
        String arg = this.m_args[0];
        if ((arg = arg.toLowerCase()).startsWith("http")) {
            try {
                URL url = new URL(arg);
                this.m_url = "rmi://" + url.getHost();
            }
            catch (MalformedURLException e) {
                this.usage();
            }
        } else {
            this.m_url = arg;
        }
    }

    private void registerShutDownHook() {
        this.m_context.registerShutdownHook();
    }

    private void createAppContext() {
        File homeDir = new File(System.getProperty("user.home"));
        String homeUrl = homeDir.toURI().toString();
        if (homeUrl.endsWith(File.separator)) {
            homeUrl = homeUrl.substring(0, homeUrl.length() - 1);
        }
        System.err.println("user.home.url = " + homeUrl);
        System.setProperty("user.home.url", homeUrl);
        System.err.println("opennms.poller.server.url = " + this.m_url);
        System.setProperty("opennms.poller.server.url", this.m_url);
        String[] configs = new String[]{"classpath:/META-INF/opennms/applicationContext-remotePollerBackEnd.xml", "classpath:/META-INF/opennms/applicationContext-pollerFrontEnd.xml", "classpath:/META-INF/opennms/applicationContext-ws-gui.xml"};
        this.m_context = new ClassPathXmlApplicationContext(configs);
        this.m_frontEnd = (PollerFrontEnd)this.m_context.getBean("pollerFrontEnd");
    }

    private void usage() {
        System.err.println("\tjava -jar opennms-webstart.jar <serverUrl>");
        System.exit(1);
    }

    public static void main(String[] args) {
        new Main(args).run();
    }
}

