/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.filter.Column;
import org.opennms.netmgt.config.filter.DatabaseSchema;
import org.opennms.netmgt.config.filter.Join;
import org.opennms.netmgt.config.filter.Table;

public final class DatabaseSchemaConfigFactory {
    private static DatabaseSchemaConfigFactory m_singleton = null;
    private DatabaseSchema m_config;
    private Map<String, Join> m_primaryJoins = null;
    private static boolean m_loaded = false;

    private DatabaseSchemaConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileReader cfgIn = new FileReader(configFile);
        this.parseXML(cfgIn);
        cfgIn.close();
    }

    public DatabaseSchemaConfigFactory(Reader reader) throws IOException, MarshalException, ValidationException {
        this.parseXML(reader);
    }

    private void parseXML(Reader rdr) throws IOException, MarshalException, ValidationException {
        this.m_config = (DatabaseSchema)Unmarshaller.unmarshal(DatabaseSchema.class, (Reader)rdr);
        this.finishConstruction();
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.DB_SCHEMA_FILE_NAME);
        m_singleton = new DatabaseSchemaConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        DatabaseSchemaConfigFactory.init();
    }

    public static synchronized DatabaseSchemaConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(DatabaseSchemaConfigFactory instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    public synchronized DatabaseSchema getDatabaseSchema() {
        return this.m_config;
    }

    public Table getPrimaryTable() {
        Enumeration<Table> e = this.getDatabaseSchema().enumerateTable();
        while (e.hasMoreElements()) {
            Table t = e.nextElement();
            if (t.getVisable() != null && !t.getVisable().equalsIgnoreCase("true") || t.getKey() == null || !t.getKey().equals("primary")) continue;
            return t;
        }
        return null;
    }

    public Table getTableByName(String name) {
        Enumeration<Table> e = this.getDatabaseSchema().enumerateTable();
        while (e.hasMoreElements()) {
            Table t = e.nextElement();
            if (t.getVisable() != null && !t.getVisable().equalsIgnoreCase("true") || t.getName() == null || !t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    public Table findTableByVisableColumn(String colName) {
        Table table = null;
        Enumeration<Table> etbl = this.getDatabaseSchema().enumerateTable();
        block0: while (etbl.hasMoreElements()) {
            Table t = etbl.nextElement();
            Enumeration<Column> ecol = t.enumerateColumn();
            while (ecol.hasMoreElements()) {
                Column col = ecol.nextElement();
                if (col.getVisable() != null && !col.getVisable().equalsIgnoreCase("true") || !col.getName().equalsIgnoreCase(colName)) continue;
                table = t;
                break block0;
            }
        }
        return table;
    }

    public int getTableCount() {
        return this.getDatabaseSchema().getTableCount();
    }

    public String constructJoinExprForTable(Table t) {
        StringBuffer buf = new StringBuffer();
        Join[] joins = this.getPrimaryJoinsForTable(t);
        for (int i = 0; i < joins.length; ++i) {
            Join j = joins[i];
            if (i != 0) {
                buf.append(" AND ");
            }
            buf.append(i == 0 ? t.getName() : joins[i - 1].getTable()).append('.').append(j.getColumn());
            buf.append(" = ");
            buf.append(j.getTable()).append('.').append(j.getTableColumn());
        }
        return buf.toString();
    }

    public String[] getJoinTablesForTable(Table t) {
        Join[] joins = this.getPrimaryJoinsForTable(t);
        String[] tables = new String[joins.length + 1];
        tables[joins.length] = t.getName();
        for (int i = 0; i < joins.length; ++i) {
            tables[joins.length - 1 - i] = joins[i].getTable();
        }
        return tables;
    }

    public Join[] getPrimaryJoinsForTable(Table t) {
        Table primary = this.getPrimaryTable();
        Join j = this.m_primaryJoins.get(t.getName());
        ArrayList<Join> joins = new ArrayList<Join>();
        while (j != null && j.getTable() != null && !j.getTable().equals(primary.getName())) {
            joins.add(j);
            j = this.m_primaryJoins.get(j.getTable());
        }
        if (j != null) {
            joins.add(j);
        }
        return joins.toArray(new Join[joins.size()]);
    }

    private void finishConstruction() {
        Table primary = this.getPrimaryTable();
        HashSet<String> joinableSet = new HashSet<String>();
        HashMap<String, Join> primaryJoins = new HashMap<String, Join>();
        joinableSet.add(primary.getName());
        int joinableCount = 0;
        while (joinableCount < joinableSet.size()) {
            joinableCount = joinableSet.size();
            HashSet<String> newSet = new HashSet<String>(joinableSet);
            Enumeration<Table> e = this.getDatabaseSchema().enumerateTable();
            while (e.hasMoreElements()) {
                Table t = e.nextElement();
                if (joinableSet.contains(t.getName()) || t.getVisable() != null && !t.getVisable().equalsIgnoreCase("true")) continue;
                Enumeration<Join> ejoin = t.enumerateJoin();
                while (ejoin.hasMoreElements()) {
                    Join j = ejoin.nextElement();
                    if (!joinableSet.contains(j.getTable())) continue;
                    newSet.add(t.getName());
                    primaryJoins.put(t.getName(), j);
                }
            }
            joinableSet = newSet;
        }
        this.m_primaryJoins = Collections.synchronizedMap(primaryJoins);
    }
}

