/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.CollectdConfig;
import org.opennms.netmgt.config.CollectdPackage;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;

public class CollectdConfigFactory {
    static final String SELECT_METHOD_MIN = "min";
    private static CollectdConfigFactory m_singleton = null;
    private static boolean m_loaded = false;
    private static boolean m_verifyServer;
    private static String m_localServer;
    private CollectdConfig m_collectdConfig;

    Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public synchronized void rebuildPackageIpListMap() {
        this.m_collectdConfig.rebuildPackageIpListMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollectdConfigFactory(String configFile, String localServer, boolean verifyServer) throws IOException, MarshalException, ValidationException {
        InputStreamReader rdr = new InputStreamReader(new FileInputStream(configFile));
        try {
            this.initialize(rdr, localServer, verifyServer);
        }
        finally {
            rdr.close();
        }
    }

    public CollectdConfigFactory(Reader rdr, String localServer, boolean verifyServer) throws IOException, MarshalException, ValidationException {
        this.initialize(rdr, localServer, verifyServer);
    }

    private void initialize(Reader rdr, String localServer, boolean verifyServer) throws MarshalException, ValidationException, IOException {
        m_verifyServer = verifyServer;
        m_localServer = localServer;
        CollectdConfiguration config = (CollectdConfiguration)Unmarshaller.unmarshal(CollectdConfiguration.class, (Reader)rdr);
        this.m_collectdConfig = new CollectdConfig(config, localServer, verifyServer);
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        OpennmsServerConfigFactory.init();
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME);
        ThreadCategory.getInstance(CollectdConfigFactory.class).debug((Object)("init: config file path: " + cfgFile.getPath()));
        m_singleton = new CollectdConfigFactory(cfgFile.getPath(), OpennmsServerConfigFactory.getInstance().getServerName(), OpennmsServerConfigFactory.getInstance().verifyServer());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        CollectdConfigFactory.init();
    }

    public synchronized void saveCurrent() throws MarshalException, IOException, ValidationException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME);
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)this.m_collectdConfig.getConfig(), (Writer)stringWriter);
        if (stringWriter.toString() != null) {
            FileWriter fileWriter = new FileWriter(cfgFile);
            fileWriter.write(stringWriter.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        CollectdConfigFactory.reload();
    }

    public static synchronized CollectdConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(CollectdConfigFactory instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    public CollectdConfig getCollectdConfig() {
        return this.m_collectdConfig;
    }

    public CollectdPackage getPackage(String name) {
        return this.m_collectdConfig.getPackage(name);
    }

    public synchronized boolean packageExists(String name) {
        return this.m_collectdConfig.getPackage(name) != null;
    }

    public boolean domainExists(String name) {
        return this.m_collectdConfig.domainExists(name);
    }

    public boolean isServiceCollectionEnabled(String ipAddr, String svcName) {
        return this.m_collectdConfig.isServiceCollectionEnabled(ipAddr, svcName);
    }
}

