/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsServiceType;
import org.springframework.core.style.ToStringCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="events")
public class OnmsEvent
extends OnmsEntity
implements Serializable {
    private static final long serialVersionUID = -7412025003474162992L;
    private Integer m_eventId;
    private String m_eventUei;
    private Date m_eventTime;
    private String m_eventHost;
    private String m_eventSource;
    private String m_ipAddr;
    private OnmsDistPoller m_distPoller;
    private String m_eventSnmpHost;
    private OnmsServiceType m_serviceType;
    private String m_eventSnmp;
    private String m_eventParms;
    private Date m_eventCreateTime;
    private String m_eventDescr;
    private String m_eventLogGroup;
    private String m_eventLogMsg;
    private Integer m_eventSeverity;
    private String m_eventPathOutage;
    private String m_eventCorrelation;
    private Integer m_eventSuppressedCount;
    private String m_eventOperInstruct;
    private String m_eventAutoAction;
    private String m_eventOperAction;
    private String m_eventOperActionMenuText;
    private String m_eventNotification;
    private String m_eventTTicket;
    private Integer m_eventTTicketState;
    private String m_eventForward;
    private String m_eventMouseOverText;
    private String m_eventLog;
    private String m_eventDisplay;
    private String m_eventAckUser;
    private Date m_eventAckTime;
    private OnmsAlarm m_alarm;
    private OnmsNode m_node;
    private Set<OnmsNotification> m_notifications = new HashSet<OnmsNotification>();
    private Set<OnmsOutage> m_associatedServiceRegainedOutages = new HashSet<OnmsOutage>();
    private Set<OnmsOutage> m_associatedServiceLostOutages = new HashSet<OnmsOutage>();

    public OnmsEvent(Integer eventid, String eventuei, Date eventtime, String eventhost, String eventsource, String ipaddr, OnmsDistPoller distPoller, String eventsnmphost, OnmsServiceType service, String eventsnmp, String eventparms, Date eventcreatetime, String eventdescr, String eventloggroup, String eventlogmsg, Integer eventseverity, String eventpathoutage, String eventcorrelation, Integer eventsuppressedcount, String eventoperinstruct, String eventautoaction, String eventoperaction, String eventoperactionmenutext, String eventnotification, String eventtticket, Integer eventtticketstate, String eventforward, String eventmouseovertext, String eventlog, String eventdisplay, String eventackuser, Date eventacktime, OnmsAlarm alarm, OnmsNode node, Set<OnmsNotification> notifications, Set<OnmsOutage> outagesBySvcregainedeventid, Set<OnmsOutage> outagesBySvclosteventid) {
        this.m_eventId = eventid;
        this.m_eventUei = eventuei;
        this.m_eventTime = eventtime;
        this.m_eventHost = eventhost;
        this.m_eventSource = eventsource;
        this.m_ipAddr = ipaddr;
        this.m_distPoller = distPoller;
        this.m_eventSnmpHost = eventsnmphost;
        this.m_serviceType = service;
        this.m_eventSnmp = eventsnmp;
        this.m_eventParms = eventparms;
        this.m_eventCreateTime = eventcreatetime;
        this.m_eventDescr = eventdescr;
        this.m_eventLogGroup = eventloggroup;
        this.m_eventLogMsg = eventlogmsg;
        this.m_eventSeverity = eventseverity;
        this.m_eventPathOutage = eventpathoutage;
        this.m_eventCorrelation = eventcorrelation;
        this.m_eventSuppressedCount = eventsuppressedcount;
        this.m_eventOperInstruct = eventoperinstruct;
        this.m_eventAutoAction = eventautoaction;
        this.m_eventOperAction = eventoperaction;
        this.m_eventOperActionMenuText = eventoperactionmenutext;
        this.m_eventNotification = eventnotification;
        this.m_eventTTicket = eventtticket;
        this.m_eventTTicketState = eventtticketstate;
        this.m_eventForward = eventforward;
        this.m_eventMouseOverText = eventmouseovertext;
        this.m_eventLog = eventlog;
        this.m_eventDisplay = eventdisplay;
        this.m_eventAckUser = eventackuser;
        this.m_eventAckTime = eventacktime;
        this.m_alarm = alarm;
        this.m_node = node;
        this.m_notifications = notifications;
        this.m_associatedServiceRegainedOutages = outagesBySvcregainedeventid;
        this.m_associatedServiceLostOutages = outagesBySvclosteventid;
    }

    public OnmsEvent() {
    }

    public OnmsEvent(Integer eventid, String eventuei, Date eventtime, String eventsource, OnmsDistPoller distPoller, Date eventcreatetime, Integer eventseverity, String eventlog, String eventdisplay, OnmsNode node, Set<OnmsNotification> notifications, Set<OnmsOutage> outagesBySvcregainedeventid, Set<OnmsOutage> outagesBySvclosteventid, Set alarms) {
        this.m_eventId = eventid;
        this.m_eventUei = eventuei;
        this.m_eventTime = eventtime;
        this.m_eventSource = eventsource;
        this.m_distPoller = distPoller;
        this.m_eventCreateTime = eventcreatetime;
        this.m_eventSeverity = eventseverity;
        this.m_eventLog = eventlog;
        this.m_eventDisplay = eventdisplay;
        this.m_node = node;
        this.m_notifications = notifications;
        this.m_associatedServiceRegainedOutages = outagesBySvcregainedeventid;
        this.m_associatedServiceLostOutages = outagesBySvclosteventid;
    }

    @Id
    @Column(name="eventId")
    @SequenceGenerator(name="eventSequence", sequenceName="eventsNxtId")
    @GeneratedValue(generator="eventSequence")
    public Integer getId() {
        return this.m_eventId;
    }

    public void setId(Integer eventid) {
        this.m_eventId = eventid;
    }

    @Column(name="eventUei", length=256, nullable=false)
    public String getEventUei() {
        return this.m_eventUei;
    }

    public void setEventUei(String eventuei) {
        this.m_eventUei = eventuei;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="eventTime", nullable=false)
    public Date getEventTime() {
        return this.m_eventTime;
    }

    public void setEventTime(Date eventtime) {
        this.m_eventTime = eventtime;
    }

    @Column(name="eventHost", length=256)
    public String getEventHost() {
        return this.m_eventHost;
    }

    public void setEventHost(String eventhost) {
        this.m_eventHost = eventhost;
    }

    @Column(name="eventSource", length=128, nullable=false)
    public String getEventSource() {
        return this.m_eventSource;
    }

    public void setEventSource(String eventsource) {
        this.m_eventSource = eventsource;
    }

    @Column(name="ipAddr", length=16)
    public String getIpAddr() {
        return this.m_ipAddr;
    }

    public void setIpAddr(String ipaddr) {
        this.m_ipAddr = ipaddr;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="eventDpName", nullable=false)
    public OnmsDistPoller getDistPoller() {
        return this.m_distPoller;
    }

    public void setDistPoller(OnmsDistPoller distPoller) {
        this.m_distPoller = distPoller;
    }

    @Column(name="eventSnmpHost", length=256)
    public String getEventSnmpHost() {
        return this.m_eventSnmpHost;
    }

    public void setEventSnmpHost(String eventsnmphost) {
        this.m_eventSnmpHost = eventsnmphost;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="serviceId", nullable=true)
    public OnmsServiceType getServiceType() {
        return this.m_serviceType;
    }

    public void setServiceType(OnmsServiceType serviceType) {
        this.m_serviceType = serviceType;
    }

    @Column(name="eventSnmp", length=256)
    public String getEventSnmp() {
        return this.m_eventSnmp;
    }

    public void setEventSnmp(String eventsnmp) {
        this.m_eventSnmp = eventsnmp;
    }

    @Column(name="eventParms", length=1024)
    public String getEventParms() {
        return this.m_eventParms;
    }

    public void setEventParms(String eventparms) {
        this.m_eventParms = eventparms;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="eventCreateTime", nullable=false)
    public Date getEventCreateTime() {
        return this.m_eventCreateTime;
    }

    public void setEventCreateTime(Date eventcreatetime) {
        this.m_eventCreateTime = eventcreatetime;
    }

    @Column(name="eventDescr", length=4000)
    public String getEventDescr() {
        return this.m_eventDescr;
    }

    public void setEventDescr(String eventdescr) {
        this.m_eventDescr = eventdescr;
    }

    @Column(name="eventLogGroup", length=32)
    public String getEventLogGroup() {
        return this.m_eventLogGroup;
    }

    public void setEventLogGroup(String eventloggroup) {
        this.m_eventLogGroup = eventloggroup;
    }

    @Column(name="eventLogMsg", length=256)
    public String getEventLogMsg() {
        return this.m_eventLogMsg;
    }

    public void setEventLogMsg(String eventlogmsg) {
        this.m_eventLogMsg = eventlogmsg;
    }

    @Column(name="eventSeverity", nullable=false)
    public Integer getEventSeverity() {
        return this.m_eventSeverity;
    }

    public void setEventSeverity(Integer severity) {
        this.m_eventSeverity = severity;
    }

    @Column(name="eventPathOutage", length=1024)
    public String getEventPathOutage() {
        return this.m_eventPathOutage;
    }

    public void setEventPathOutage(String eventpathoutage) {
        this.m_eventPathOutage = eventpathoutage;
    }

    @Column(name="eventCorrelation", length=1024)
    public String getEventCorrelation() {
        return this.m_eventCorrelation;
    }

    public void setEventCorrelation(String eventcorrelation) {
        this.m_eventCorrelation = eventcorrelation;
    }

    @Column(name="eventSuppressedCount")
    public Integer getEventSuppressedCount() {
        return this.m_eventSuppressedCount;
    }

    public void setEventSuppressedCount(Integer eventsuppressedcount) {
        this.m_eventSuppressedCount = eventsuppressedcount;
    }

    @Column(name="eventOperInstruct", length=1024)
    public String getEventOperInstruct() {
        return this.m_eventOperInstruct;
    }

    public void setEventOperInstruct(String eventoperinstruct) {
        this.m_eventOperInstruct = eventoperinstruct;
    }

    @Column(name="eventAutoAction", length=256)
    public String getEventAutoAction() {
        return this.m_eventAutoAction;
    }

    public void setEventAutoAction(String eventautoaction) {
        this.m_eventAutoAction = eventautoaction;
    }

    @Column(name="eventOperAction", length=256)
    public String getEventOperAction() {
        return this.m_eventOperAction;
    }

    public void setEventOperAction(String eventoperaction) {
        this.m_eventOperAction = eventoperaction;
    }

    @Column(name="eventOperActionMenuText", length=64)
    public String getEventOperActionMenuText() {
        return this.m_eventOperActionMenuText;
    }

    public void setEventOperActionMenuText(String eventOperActionMenuText) {
        this.m_eventOperActionMenuText = eventOperActionMenuText;
    }

    @Column(name="eventNotification", length=128)
    public String getEventNotification() {
        return this.m_eventNotification;
    }

    public void setEventNotification(String eventnotification) {
        this.m_eventNotification = eventnotification;
    }

    @Column(name="eventTTicket", length=128)
    public String getEventTTicket() {
        return this.m_eventTTicket;
    }

    public void setEventTTicket(String eventtticket) {
        this.m_eventTTicket = eventtticket;
    }

    @Column(name="eventTTicketState")
    public Integer getEventTTicketState() {
        return this.m_eventTTicketState;
    }

    public void setEventTTicketState(Integer eventtticketstate) {
        this.m_eventTTicketState = eventtticketstate;
    }

    @Column(name="eventForward", length=256)
    public String getEventForward() {
        return this.m_eventForward;
    }

    public void setEventForward(String eventforward) {
        this.m_eventForward = eventforward;
    }

    @Column(name="eventMouseOverText", length=64)
    public String getEventMouseOverText() {
        return this.m_eventMouseOverText;
    }

    public void setEventMouseOverText(String eventmouseovertext) {
        this.m_eventMouseOverText = eventmouseovertext;
    }

    @Column(name="eventLog", length=1, nullable=false)
    public String getEventLog() {
        return this.m_eventLog;
    }

    public void setEventLog(String eventlog) {
        this.m_eventLog = eventlog;
    }

    @Column(name="eventDisplay", length=1, nullable=false)
    public String getEventDisplay() {
        return this.m_eventDisplay;
    }

    public void setEventDisplay(String eventdisplay) {
        this.m_eventDisplay = eventdisplay;
    }

    @Column(name="eventAckUser", length=256)
    public String getEventAckUser() {
        return this.m_eventAckUser;
    }

    public void setEventAckUser(String eventackuser) {
        this.m_eventAckUser = eventackuser;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="eventAckTime")
    public Date getEventAckTime() {
        return this.m_eventAckTime;
    }

    public void setEventAckTime(Date eventacktime) {
        this.m_eventAckTime = eventacktime;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="alarmId")
    public OnmsAlarm getAlarm() {
        return this.m_alarm;
    }

    public void setAlarm(OnmsAlarm alarm) {
        this.m_alarm = alarm;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @OneToMany(mappedBy="event", fetch=FetchType.LAZY)
    public Set<OnmsNotification> getNotifications() {
        return this.m_notifications;
    }

    public void setNotifications(Set<OnmsNotification> notifications) {
        this.m_notifications = notifications;
    }

    @OneToMany(mappedBy="serviceRegainedEvent", fetch=FetchType.LAZY)
    public Set<OnmsOutage> getAssociatedServiceRegainedOutages() {
        return this.m_associatedServiceRegainedOutages;
    }

    public void setAssociatedServiceRegainedOutages(Set<OnmsOutage> outagesBySvcregainedeventid) {
        this.m_associatedServiceRegainedOutages = outagesBySvcregainedeventid;
    }

    @OneToMany(mappedBy="serviceLostEvent", fetch=FetchType.LAZY)
    public Set<OnmsOutage> getAssociatedServiceLostOutages() {
        return this.m_associatedServiceLostOutages;
    }

    public void setAssociatedServiceLostOutages(Set<OnmsOutage> outagesBySvclosteventid) {
        this.m_associatedServiceLostOutages = outagesBySvclosteventid;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("eventid", (Object)this.getId()).toString();
    }

    @Override
    public void visit(EntityVisitor visitor) {
        throw new RuntimeException("visitor method not implemented");
    }
}

